/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.external.handlers.runtime;

import com.google.inject.Inject;
import com.mulesoft.agent.configuration.Configurable;
import com.mulesoft.agent.configuration.PostConfigure;
import com.mulesoft.agent.exception.AgentEnableOperationException;
import com.mulesoft.agent.external.handlers.ConfigurableExternalHandler;
import com.mulesoft.agent.external.handlers.PATCH;
import com.mulesoft.agent.services.RuntimeConfigurationService;
import com.mulesoft.agent.util.ResponseHelper;
import java.util.Map;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Named(value="runtime.configuration.request.handler")
@Path(value="/runtime")
@Singleton
public class RuntimeConfigurationRequestHandler
extends ConfigurableExternalHandler {
    @Configurable(value="true")
    private boolean enabled;
    private ResponseHelper responseHelper;
    @Inject
    private RuntimeConfigurationService runtimeConfigurationService;

    @PostConfigure
    public void start() {
        this.responseHelper = new ResponseHelper().addErrorMapping(IllegalArgumentException.class, Response.Status.BAD_REQUEST);
    }

    public void enable(boolean b) throws AgentEnableOperationException {
        this.enabled = b;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @PATCH
    @Path(value="configuration/")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response setConfiguration(Map<String, String> configurationEntries, @QueryParam(value="verbose") boolean verbose) {
        return this.responseHelper.response(() -> {
            this.runtimeConfigurationService.setConfiguration(configurationEntries);
            return "{ \"runtime.configuration\":{\"status\":\"updated\"} }";
        }, verbose);
    }

    @GET
    @Path(value="configuration/maven/repositories/")
    @Produces(value={"application/json"})
    public Response getMavenRepositories(@QueryParam(value="verbose") boolean verbose) {
        return this.responseHelper.response(() -> this.runtimeConfigurationService.getMavenRepositories(), verbose);
    }
}

