/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.failsafe;

import java.time.Duration;
import java.util.concurrent.atomic.AtomicInteger;

public class ExecutionContext {
    private final Duration startTime;
    AtomicInteger attempts = new AtomicInteger();
    volatile Object lastResult;
    volatile Throwable lastFailure;

    ExecutionContext(Duration startTime) {
        this.startTime = startTime;
    }

    private ExecutionContext(ExecutionContext context) {
        this.startTime = context.startTime;
        this.attempts = context.attempts;
        this.lastResult = context.lastResult;
        this.lastFailure = context.lastFailure;
    }

    public Duration getElapsedTime() {
        return Duration.ofNanos(System.nanoTime() - this.startTime.toNanos());
    }

    public int getAttemptCount() {
        return this.attempts.get();
    }

    public <T extends Throwable> T getLastFailure() {
        return (T)this.lastFailure;
    }

    public <T> T getLastResult() {
        return (T)this.lastResult;
    }

    public <T> T getLastResult(T defaultValue) {
        return (T)(this.lastResult != null ? this.lastResult : defaultValue);
    }

    public Duration getStartTime() {
        return this.startTime;
    }

    public ExecutionContext copy() {
        return new ExecutionContext(this);
    }
}

