/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.cluster.internal;

import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.core.Member;
import com.hazelcast.core.MemberSelector;
import com.hazelcast.core.MultiExecutionCallback;
import com.hazelcast.monitor.LocalExecutorStats;
import com.mulesoft.mule.runtime.module.cluster.internal.HazelcastClusterManager;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class HazelcastExecutorService
implements IExecutorService {
    private static final String EXECUTION_SERVICE_ID = "THROTTLING_ALGORITHM_EXECUTION";
    private HazelcastInstance hazelcast;

    public HazelcastExecutorService(HazelcastClusterManager manager) {
        this.hazelcast = manager.getHazelcastInstance();
        if (!manager.isClientModeEnabled()) {
            this.hazelcast.getConfig().getExecutorConfig(EXECUTION_SERVICE_ID).setPoolSize(100);
        }
    }

    public void shutdown() {
        this.hazelcast.getExecutorService(EXECUTION_SERVICE_ID).shutdown();
    }

    public List<Runnable> shutdownNow() {
        return this.hazelcast.getExecutorService(EXECUTION_SERVICE_ID).shutdownNow();
    }

    public boolean isShutdown() {
        return this.hazelcast.getExecutorService(EXECUTION_SERVICE_ID).isShutdown();
    }

    public boolean isTerminated() {
        return this.hazelcast.getExecutorService(EXECUTION_SERVICE_ID).isTerminated();
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.hazelcast.getExecutorService(EXECUTION_SERVICE_ID).awaitTermination(timeout, unit);
    }

    public <T> Future<T> submit(Callable<T> task) {
        return this.hazelcast.getExecutorService(EXECUTION_SERVICE_ID).submit(task);
    }

    public <T> Future<T> submit(Runnable task, T result) {
        return this.hazelcast.getExecutorService(EXECUTION_SERVICE_ID).submit(task, result);
    }

    public Future<?> submit(Runnable task) {
        return this.hazelcast.getExecutorService(EXECUTION_SERVICE_ID).submit(task);
    }

    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.hazelcast.getExecutorService(EXECUTION_SERVICE_ID).invokeAll(tasks);
    }

    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.hazelcast.getExecutorService(EXECUTION_SERVICE_ID).invokeAll(tasks, timeout, unit);
    }

    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return (T)this.hazelcast.getExecutorService(EXECUTION_SERVICE_ID).invokeAny(tasks);
    }

    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return (T)this.hazelcast.getExecutorService(EXECUTION_SERVICE_ID).invokeAny(tasks, timeout, unit);
    }

    public void execute(Runnable command) {
        this.hazelcast.getExecutorService(EXECUTION_SERVICE_ID).execute(command);
    }

    public String getPartitionKey() {
        return this.hazelcast.getExecutorService(EXECUTION_SERVICE_ID).getPartitionKey();
    }

    public String getName() {
        return this.hazelcast.getExecutorService(EXECUTION_SERVICE_ID).getName();
    }

    public String getServiceName() {
        return this.hazelcast.getExecutorService(EXECUTION_SERVICE_ID).getServiceName();
    }

    public void destroy() {
        this.hazelcast.getExecutorService(EXECUTION_SERVICE_ID).destroy();
    }

    public void execute(Runnable command, MemberSelector memberSelector) {
        this.hazelcast.getExecutorService(EXECUTION_SERVICE_ID).execute(command, memberSelector);
    }

    public void executeOnKeyOwner(Runnable command, Object key) {
        this.hazelcast.getExecutorService(EXECUTION_SERVICE_ID).executeOnKeyOwner(command, key);
    }

    public void executeOnMember(Runnable command, Member member) {
        this.hazelcast.getExecutorService(EXECUTION_SERVICE_ID).executeOnMember(command, member);
    }

    public void executeOnMembers(Runnable command, Collection<Member> members) {
        this.hazelcast.getExecutorService(EXECUTION_SERVICE_ID).executeOnMembers(command, members);
    }

    public void executeOnMembers(Runnable command, MemberSelector memberSelector) {
        this.hazelcast.getExecutorService(EXECUTION_SERVICE_ID).executeOnMembers(command, memberSelector);
    }

    public void executeOnAllMembers(Runnable command) {
        this.hazelcast.getExecutorService(EXECUTION_SERVICE_ID).executeOnAllMembers(command);
    }

    public <T> Future<T> submit(Callable<T> task, MemberSelector memberSelector) {
        return this.hazelcast.getExecutorService(EXECUTION_SERVICE_ID).submit(task, memberSelector);
    }

    public <T> Future<T> submitToKeyOwner(Callable<T> task, Object key) {
        return this.hazelcast.getExecutorService(EXECUTION_SERVICE_ID).submitToKeyOwner(task, key);
    }

    public <T> Future<T> submitToMember(Callable<T> task, Member member) {
        return this.hazelcast.getExecutorService(EXECUTION_SERVICE_ID).submitToMember(task, member);
    }

    public <T> Map<Member, Future<T>> submitToMembers(Callable<T> task, Collection<Member> members) {
        return this.hazelcast.getExecutorService(EXECUTION_SERVICE_ID).submitToMembers(task, members);
    }

    public <T> Map<Member, Future<T>> submitToMembers(Callable<T> task, MemberSelector memberSelector) {
        return this.hazelcast.getExecutorService(EXECUTION_SERVICE_ID).submitToMembers(task, memberSelector);
    }

    public <T> Map<Member, Future<T>> submitToAllMembers(Callable<T> task) {
        return this.hazelcast.getExecutorService(EXECUTION_SERVICE_ID).submitToAllMembers(task);
    }

    public <T> void submit(Runnable task, ExecutionCallback<T> callback) {
        this.hazelcast.getExecutorService(EXECUTION_SERVICE_ID).submit(task, callback);
    }

    public <T> void submit(Runnable task, MemberSelector memberSelector, ExecutionCallback<T> callback) {
        this.hazelcast.getExecutorService(EXECUTION_SERVICE_ID).submit(task, memberSelector, callback);
    }

    public <T> void submitToKeyOwner(Runnable task, Object key, ExecutionCallback<T> callback) {
        this.hazelcast.getExecutorService(EXECUTION_SERVICE_ID).submitToKeyOwner(task, key, callback);
    }

    public <T> void submitToMember(Runnable task, Member member, ExecutionCallback<T> callback) {
        this.hazelcast.getExecutorService(EXECUTION_SERVICE_ID).submitToMember(task, member, callback);
    }

    public void submitToMembers(Runnable task, Collection<Member> members, MultiExecutionCallback callback) {
        this.hazelcast.getExecutorService(EXECUTION_SERVICE_ID).submitToMembers(task, members, callback);
    }

    public void submitToMembers(Runnable task, MemberSelector memberSelector, MultiExecutionCallback callback) {
        this.hazelcast.getExecutorService(EXECUTION_SERVICE_ID).submitToMembers(task, memberSelector, callback);
    }

    public void submitToAllMembers(Runnable task, MultiExecutionCallback callback) {
        this.hazelcast.getExecutorService(EXECUTION_SERVICE_ID).submitToAllMembers(task, callback);
    }

    public <T> void submit(Callable<T> task, ExecutionCallback<T> callback) {
        this.hazelcast.getExecutorService(EXECUTION_SERVICE_ID).submit(task, callback);
    }

    public <T> void submit(Callable<T> task, MemberSelector memberSelector, ExecutionCallback<T> callback) {
        this.hazelcast.getExecutorService(EXECUTION_SERVICE_ID).submit(task, memberSelector, callback);
    }

    public <T> void submitToKeyOwner(Callable<T> task, Object key, ExecutionCallback<T> callback) {
        this.hazelcast.getExecutorService(EXECUTION_SERVICE_ID).submitToKeyOwner(task, key, callback);
    }

    public <T> void submitToMember(Callable<T> task, Member member, ExecutionCallback<T> callback) {
        this.hazelcast.getExecutorService(EXECUTION_SERVICE_ID).submitToKeyOwner(task, (Object)member, callback);
    }

    public <T> void submitToMembers(Callable<T> task, Collection<Member> members, MultiExecutionCallback callback) {
        this.hazelcast.getExecutorService(EXECUTION_SERVICE_ID).submitToMembers(task, members, callback);
    }

    public <T> void submitToMembers(Callable<T> task, MemberSelector memberSelector, MultiExecutionCallback callback) {
        this.hazelcast.getExecutorService(EXECUTION_SERVICE_ID).submitToMembers(task, memberSelector, callback);
    }

    public <T> void submitToAllMembers(Callable<T> task, MultiExecutionCallback callback) {
        this.hazelcast.getExecutorService(EXECUTION_SERVICE_ID).submitToAllMembers(task, callback);
    }

    public LocalExecutorStats getLocalExecutorStats() {
        return this.hazelcast.getExecutorService(EXECUTION_SERVICE_ID).getLocalExecutorStats();
    }
}

