/*
 * Decompiled with CFR 0.152.
 */
package org.mule.apache.xerces.impl.xs.util;

import java.util.AbstractList;
import org.mule.apache.xerces.xs.ShortList;
import org.mule.apache.xerces.xs.XSException;

public final class ShortListImpl
extends AbstractList
implements ShortList {
    public static final ShortListImpl EMPTY_LIST = new ShortListImpl(new short[0], 0);
    private final short[] fArray;
    private final int fLength;

    public ShortListImpl(short[] array, int length) {
        this.fArray = array;
        this.fLength = length;
    }

    @Override
    public int getLength() {
        return this.fLength;
    }

    @Override
    public boolean contains(short item) {
        for (int i = 0; i < this.fLength; ++i) {
            if (this.fArray[i] != item) continue;
            return true;
        }
        return false;
    }

    @Override
    public short item(int index) throws XSException {
        if (index < 0 || index >= this.fLength) {
            throw new XSException(2, null);
        }
        return this.fArray[index];
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ShortList)) {
            return false;
        }
        ShortList rhs = (ShortList)obj;
        if (this.fLength != rhs.getLength()) {
            return false;
        }
        for (int i = 0; i < this.fLength; ++i) {
            if (this.fArray[i] == rhs.item(i)) continue;
            return false;
        }
        return true;
    }

    public Object get(int index) {
        if (index >= 0 && index < this.fLength) {
            return new Short(this.fArray[index]);
        }
        throw new IndexOutOfBoundsException("Index: " + index);
    }

    @Override
    public int size() {
        return this.getLength();
    }
}

