/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.validation;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.util.ComponentAstPredicatesFactory;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.api.validation.ValidationResultItem;

public abstract class OperationDoesNotHaveForbiddenComponent
implements Validation {
    private static final ComponentIdentifier OPERATION_IDENTIFIER = ComponentIdentifier.builder().namespace("operation").name("def").build();

    protected abstract ComponentIdentifier forbiddenComponentIdentifier();

    public String getName() {
        return String.format("Operation doesn't have '%s'", this.forbiddenComponentIdentifier());
    }

    public String getDescription() {
        return String.format("Operations cannot have a '%s' component within", this.forbiddenComponentIdentifier());
    }

    public Validation.Level getLevel() {
        return Validation.Level.ERROR;
    }

    public Predicate<List<ComponentAst>> applicable() {
        return ComponentAstPredicatesFactory.topLevelElement().and(ComponentAstPredicatesFactory.currentElemement(component -> component.getIdentifier().equals(OPERATION_IDENTIFIER)));
    }

    public Optional<ValidationResultItem> validate(ComponentAst component, ArtifactAst artifact) {
        if (component.recursiveStream().anyMatch(c -> c.getIdentifier().equals(this.forbiddenComponentIdentifier()))) {
            return Optional.of(ValidationResultItem.create((ComponentAst)component, (Validation)this, (String)String.format("Usages of the component '%s' are not allowed inside a Mule Operation Definition (%s)", this.forbiddenComponentIdentifier(), OPERATION_IDENTIFIER)));
        }
        return Optional.empty();
    }
}

