/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.tracing.customization;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.tracing.customization.SpanInitialInfoUtils;
import org.mule.runtime.core.privileged.event.PrivilegedEvent;
import org.mule.runtime.tracer.api.span.info.InitialExportInfo;
import org.mule.runtime.tracer.api.span.info.InitialSpanInfo;

public class ComponentExecutionInitialSpanInfo
implements InitialSpanInfo {
    public static final String LOCATION_KEY = "location";
    public static final String CORRELATION_ID_KEY = "correlation.id";
    public static final String THREAD_START_ID_KEY = "thread.start.id";
    public static final String THREAD_START_NAME_KEY = "thread.start.name";
    protected final CoreEvent coreEvent;
    protected final Component component;
    private String suffix = "";

    public ComponentExecutionInitialSpanInfo(Component component, CoreEvent coreEvent, String suffix) {
        this.component = component;
        this.coreEvent = coreEvent;
        this.suffix = suffix;
    }

    public ComponentExecutionInitialSpanInfo(Component component, CoreEvent coreEvent) {
        this.component = component;
        this.coreEvent = coreEvent;
    }

    public Map<String, String> getInitialAttributes() {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put(LOCATION_KEY, this.getLocationAsString(this.coreEvent));
        attributes.put(CORRELATION_ID_KEY, this.coreEvent.getCorrelationId());
        attributes.put(THREAD_START_ID_KEY, Long.toString(Thread.currentThread().getId()));
        attributes.put(THREAD_START_NAME_KEY, Thread.currentThread().getName());
        this.addLoggingVariablesAsAttributes(this.coreEvent, attributes);
        return attributes;
    }

    protected String getLocationAsString(CoreEvent coreEvent) {
        return SpanInitialInfoUtils.getLocationAsString(this.component.getLocation());
    }

    private void addLoggingVariablesAsAttributes(CoreEvent coreEvent, Map<String, String> attributes) {
        Optional<Map<String, String>> loggingVariables;
        if (coreEvent instanceof PrivilegedEvent && (loggingVariables = ((PrivilegedEvent)coreEvent).getLoggingVariables()).isPresent()) {
            for (Map.Entry<String, String> entry : ((PrivilegedEvent)coreEvent).getLoggingVariables().get().entrySet()) {
                attributes.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public String getName() {
        return SpanInitialInfoUtils.getSpanName(this.component.getIdentifier()) + this.suffix;
    }

    public InitialExportInfo getInitialExportInfo() {
        return new InitialExportInfo(){

            public boolean isExportable() {
                return true;
            }
        };
    }

    public boolean isPolicySpan() {
        return this.component.getIdentifier() != null && this.component.getIdentifier().getName() != null && this.component.getIdentifier().getName().equals("execute-next");
    }

    public boolean isRootSpan() {
        return this.component.getIdentifier() != null && this.component.getIdentifier().getName() != null && this.component.getIdentifier().getName().equals("flow");
    }
}

