/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.chain;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.xml.namespace.QName;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.core.api.context.notification.FlowStackElement;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.exception.NullExceptionHandler;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.api.tracing.customization.ComponentEventBasedInitialSpanInfoProvider;
import org.mule.runtime.core.api.tracing.customization.ComponentExecutionInitialSpanInfo;
import org.mule.runtime.core.api.tracing.customization.SpanInitialInfoUtils;
import org.mule.runtime.core.internal.context.notification.DefaultFlowCallStack;
import org.mule.runtime.core.privileged.processor.chain.DefaultMessageProcessorChainBuilder;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.mule.runtime.tracer.api.span.info.InitialExportInfo;
import org.mule.runtime.tracer.api.span.info.InitialSpanInfo;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public class SubflowMessageProcessorChainBuilder
extends DefaultMessageProcessorChainBuilder
implements Component {
    private volatile Map<QName, Object> annotations = Collections.emptyMap();
    private final Object rootContainerLocationInitLock = new Object();
    private volatile Location rootContainerLocation;

    public Object getAnnotation(QName qName) {
        return this.annotations.get(qName);
    }

    public Map<QName, Object> getAnnotations() {
        return Collections.unmodifiableMap(this.annotations);
    }

    public void setAnnotations(Map<QName, Object> newAnnotations) {
        this.annotations = new HashMap<QName, Object>(newAnnotations);
    }

    public ComponentLocation getLocation() {
        return (ComponentLocation)this.getAnnotation(AbstractComponent.LOCATION_KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Location getRootContainerLocation() {
        if (this.rootContainerLocation == null) {
            Object object = this.rootContainerLocationInitLock;
            synchronized (object) {
                if (this.rootContainerLocation == null) {
                    String rootContainerName = (String)this.getAnnotation(AbstractComponent.ROOT_CONTAINER_NAME_KEY);
                    if (rootContainerName == null) {
                        rootContainerName = this.getLocation().getRootContainerName();
                    }
                    this.rootContainerLocation = Location.builder().globalName(rootContainerName).build();
                }
            }
        }
        return this.rootContainerLocation;
    }

    @Override
    protected MessageProcessorChain createSimpleChain(List<Processor> processors, Optional<ProcessingStrategy> processingStrategyOptional) {
        return new SubFlowMessageProcessorChain(this.name, processors, processingStrategyOptional);
    }

    private static class SubFlowMessageProcessorChain
    extends DefaultMessageProcessorChainBuilder.DefaultMessageProcessorChain {
        public static final ComponentIdentifier SUB_FLOW = ComponentIdentifier.buildFromStringRepresentation((String)"subflow");
        private final String subFlowName;

        SubFlowMessageProcessorChain(String name, List<Processor> processors, Optional<ProcessingStrategy> processingStrategyOptional) {
            super(name, processingStrategyOptional, processors, NullExceptionHandler.getInstance());
            this.subFlowName = name;
            this.setEventBasedInitialSpanInfoProvider(new SubFllowComponentEventBasedInitialSpanInfoProvider((Component)this));
        }

        private void pushSubFlowFlowStackElement(CoreEvent event) {
            ((DefaultFlowCallStack)event.getFlowCallStack()).push(new FlowStackElement(this.subFlowName, SUB_FLOW, null));
        }

        private void popSubFlowFlowStackElement(CoreEvent event) {
            ((DefaultFlowCallStack)event.getFlowCallStack()).pop();
        }

        @Override
        public Publisher<CoreEvent> apply(Publisher<CoreEvent> publisher) {
            return Flux.from(publisher).doOnNext(this::pushSubFlowFlowStackElement).transformDeferred(x$0 -> super.apply((Publisher<CoreEvent>)x$0)).doOnNext(this::popSubFlowFlowStackElement);
        }

        private class SubFllowComponentEventBasedInitialSpanInfoProvider
        extends ComponentEventBasedInitialSpanInfoProvider {
            SubFllowComponentEventBasedInitialSpanInfoProvider(Component component) {
                super(component);
            }

            @Override
            public InitialSpanInfo get(CoreEvent coreEvent) {
                return new SubFlowComponentExecutionInitialSpanInfo(this.component, coreEvent);
            }

            private class SubFlowComponentExecutionInitialSpanInfo
            extends ComponentExecutionInitialSpanInfo {
                public SubFlowComponentExecutionInitialSpanInfo(Component component, CoreEvent coreEvent) {
                    super(component, coreEvent);
                }

                @Override
                public String getName() {
                    return SpanInitialInfoUtils.getSpanName(SUB_FLOW);
                }

                @Override
                public InitialExportInfo getInitialExportInfo() {
                    return InitialExportInfo.DEFAULT_EXPORT_SPAN_CUSTOMIZATION_INFO;
                }
            }
        }
    }
}

