/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.profiling;

import java.util.function.Function;
import javax.inject.Inject;
import org.mule.runtime.api.config.Feature;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.config.MuleRuntimeFeature;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.profiling.ProfilingDataConsumer;
import org.mule.runtime.api.profiling.ProfilingDataProducer;
import org.mule.runtime.api.profiling.ProfilingEventContext;
import org.mule.runtime.api.profiling.ProfilingProducerScope;
import org.mule.runtime.api.profiling.threading.ThreadSnapshotCollector;
import org.mule.runtime.api.profiling.tracing.ExecutionContext;
import org.mule.runtime.api.profiling.tracing.TracingService;
import org.mule.runtime.api.profiling.type.ProfilingEventType;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.internal.profiling.DefaultProfilingService;
import org.mule.runtime.core.internal.profiling.InternalProfilingService;
import org.mule.runtime.core.internal.profiling.NoOpProfilingService;
import org.mule.runtime.core.privileged.profiling.PrivilegedProfilingService;
import org.mule.runtime.tracer.api.EventTracer;
import org.mule.runtime.tracer.api.context.getter.DistributedTraceContextGetter;
import org.mule.runtime.tracer.api.sniffer.SpanSnifferManager;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ProfilingServiceWrapper
implements InternalProfilingService,
PrivilegedProfilingService,
Lifecycle {
    @Inject
    MuleContext muleContext;
    InternalProfilingService profilingService;
    @Inject
    FeatureFlaggingService featureFlaggingService;

    public <T extends ProfilingEventContext, S> ProfilingDataProducer<T, S> getProfilingDataProducer(ProfilingEventType<T> profilingEventType) {
        return this.getProfilingService().getProfilingDataProducer(profilingEventType);
    }

    public <T extends ProfilingEventContext, S> ProfilingDataProducer<T, S> getProfilingDataProducer(ProfilingEventType<T> profilingEventType, ProfilingProducerScope producerScope) {
        return this.getProfilingService().getProfilingDataProducer(profilingEventType, producerScope);
    }

    public <T extends ProfilingEventContext, S> void registerProfilingDataProducer(ProfilingEventType<T> profilingEventType, ProfilingDataProducer<T, S> profilingDataProducer) {
        this.getProfilingService().registerProfilingDataProducer(profilingEventType, profilingDataProducer);
    }

    @Override
    public <T extends ProfilingEventContext> void registerProfilingDataConsumer(ProfilingDataConsumer<T> profilingDataConsumer) {
        if (this.profilingService instanceof PrivilegedProfilingService) {
            ((PrivilegedProfilingService)((Object)this.getProfilingService())).registerProfilingDataConsumer(profilingDataConsumer);
        }
    }

    @Override
    public void injectDistributedTraceContext(EventContext eventContext, DistributedTraceContextGetter distributedTraceContextGetter) {
        if (this.profilingService instanceof PrivilegedProfilingService) {
            ((PrivilegedProfilingService)((Object)this.getProfilingService())).injectDistributedTraceContext(eventContext, distributedTraceContextGetter);
        }
    }

    public ThreadSnapshotCollector getThreadSnapshotCollector() {
        return this.getProfilingService().getThreadSnapshotCollector();
    }

    public TracingService getTracingService() {
        return this.getProfilingService().getTracingService();
    }

    public InternalProfilingService getProfilingService() throws MuleRuntimeException {
        if (this.profilingService != null) {
            return this.profilingService;
        }
        return this.initialiseProfilingService();
    }

    @Override
    public SpanSnifferManager getSpanExportManager() {
        if (this.profilingService instanceof PrivilegedProfilingService) {
            return ((PrivilegedProfilingService)((Object)this.getProfilingService())).getSpanExportManager();
        }
        return PrivilegedProfilingService.super.getSpanExportManager();
    }

    private InternalProfilingService initialiseProfilingService() throws MuleRuntimeException {
        this.profilingService = this.featureFlaggingService.isEnabled((Feature)MuleRuntimeFeature.ENABLE_PROFILING_SERVICE) ? new DefaultProfilingService() : new NoOpProfilingService();
        try {
            this.muleContext.getInjector().inject(this.profilingService);
        }
        catch (MuleException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
        return this.profilingService;
    }

    @Override
    public <T extends ProfilingEventContext, S> Mono<S> enrichWithProfilingEventMono(Mono<S> original, ProfilingDataProducer<T, S> dataProducer, Function<S, T> transformer) {
        return this.profilingService.enrichWithProfilingEventMono(original, dataProducer, transformer);
    }

    @Override
    public <T extends ProfilingEventContext, S> Flux<S> enrichWithProfilingEventFlux(Flux<S> original, ProfilingDataProducer<T, S> dataProducer, Function<S, T> transformer) {
        return this.profilingService.enrichWithProfilingEventFlux(original, dataProducer, transformer);
    }

    @Override
    public <S> Mono<S> setCurrentExecutionContext(Mono<S> original, Function<S, ExecutionContext> executionContextSupplier) {
        return this.profilingService.setCurrentExecutionContext(original, executionContextSupplier);
    }

    @Override
    public <S> Flux<S> setCurrentExecutionContext(Flux<S> original, Function<S, ExecutionContext> executionContextSupplier) {
        return this.profilingService.setCurrentExecutionContext(original, executionContextSupplier);
    }

    @Override
    public EventTracer<CoreEvent> getCoreEventTracer() {
        return this.getProfilingService().getCoreEventTracer();
    }

    public void dispose() {
        if (this.profilingService == null) {
            this.initialiseProfilingService();
        }
        if (this.profilingService instanceof Disposable) {
            ((Disposable)this.profilingService).dispose();
        }
    }

    public void initialise() throws InitialisationException {
        if (this.profilingService == null) {
            this.initialiseProfilingService();
        }
        if (this.profilingService instanceof Initialisable) {
            ((Initialisable)this.profilingService).initialise();
        }
    }

    public void start() throws MuleException {
        if (this.profilingService == null) {
            this.initialiseProfilingService();
        }
        if (this.profilingService instanceof Startable) {
            ((Startable)this.profilingService).start();
        }
    }

    public void stop() throws MuleException {
        if (this.profilingService == null) {
            this.initialiseProfilingService();
        }
        if (this.profilingService instanceof Stoppable) {
            ((Stoppable)this.profilingService).stop();
        }
    }
}

