/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.api.component;

import org.apache.commons.lang3.StringUtils;
import org.mule.tooling.client.internal.util.Preconditions;

public class ComponentIdentifier {
    public static final String CORE_PREFIX = "mule";
    private String namespace;
    private String namespaceUri;
    private String name;

    private ComponentIdentifier() {
    }

    public ComponentIdentifier(String name, String namespace, String namespaceUri) {
        this.name = name;
        this.namespace = namespace;
        this.namespaceUri = namespaceUri;
    }

    public ComponentIdentifier(String name, String namespace) {
        this(name, namespace, null);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getNamespaceUri() {
        return this.namespaceUri;
    }

    public String getName() {
        return this.name;
    }

    public static ComponentIdentifier buildFromStringRepresentation(String componentIdentifier) {
        return ComponentIdentifier.parseComponentIdentifier(componentIdentifier);
    }

    static ComponentIdentifier parseComponentIdentifier(String componentIdentifier) {
        String identifier;
        String namespace;
        Preconditions.checkArgument(!StringUtils.isEmpty((CharSequence)componentIdentifier), "identifier cannot be an empty string or null");
        String[] values = componentIdentifier.split(":");
        if (values.length == 2) {
            namespace = values[0];
            identifier = values[1];
        } else {
            namespace = CORE_PREFIX;
            identifier = values[0];
        }
        return new Builder().namespace(namespace).name(identifier).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComponentIdentifier that = (ComponentIdentifier)o;
        if (!this.getNamespace().equalsIgnoreCase(that.getNamespace())) {
            return false;
        }
        return this.getName().equals(that.getName());
    }

    public int hashCode() {
        int result = this.getNamespace().toLowerCase().hashCode();
        result = 31 * result + this.getName().hashCode();
        return result;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return this.getNamespace().equals(CORE_PREFIX) ? this.getName() : this.getNamespace() + ":" + this.getName();
    }

    public static class Builder {
        private final ComponentIdentifier componentIdentifier = new ComponentIdentifier();

        public Builder namespace(String namespace) {
            this.componentIdentifier.namespace = namespace;
            return this;
        }

        public Builder namespaceUri(String namespaceUri) {
            this.componentIdentifier.namespaceUri = namespaceUri;
            return this;
        }

        public Builder name(String identifier) {
            this.componentIdentifier.name = identifier;
            return this;
        }

        public ComponentIdentifier build() {
            Preconditions.checkState(this.componentIdentifier.namespace != null && !this.componentIdentifier.namespace.trim().isEmpty(), "Prefix URI must be not blank");
            Preconditions.checkState(this.componentIdentifier.name != null && !this.componentIdentifier.name.trim().isEmpty(), "Name must be not blank");
            return this.componentIdentifier;
        }
    }
}

