/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.api.component.location;

import java.util.Objects;
import java.util.Optional;
import org.mule.tooling.client.api.component.TypedComponentIdentifier;
import org.mule.tooling.client.api.component.location.SourceCodeLocation;

public class LocationPart {
    private String path;
    private SourceCodeLocation sourceCodeLocation;
    private TypedComponentIdentifier identifier;

    private LocationPart() {
    }

    public LocationPart(String path, TypedComponentIdentifier identifier, Optional<SourceCodeLocation> sourceCodeLocation) {
        this.path = path;
        this.identifier = identifier;
        this.sourceCodeLocation = sourceCodeLocation.orElse(null);
    }

    public String getPartPath() {
        return this.path;
    }

    public Optional<TypedComponentIdentifier> getPartIdentifier() {
        return Optional.ofNullable(this.identifier);
    }

    public Optional<SourceCodeLocation> getSourceCodeLocation() {
        return Optional.ofNullable(this.sourceCodeLocation);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocationPart that = (LocationPart)o;
        return Objects.equals(this.path, that.path) && Objects.equals(this.getSourceCodeLocation(), that.getSourceCodeLocation()) && Objects.equals(this.identifier, that.identifier);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.getSourceCodeLocation(), this.identifier);
    }
}

