/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.error;

import java.util.Objects;
import org.mule.runtime.api.message.ErrorType;
import org.mule.sdk.api.error.MuleErrors;

public final class ErrorTypeBuilder {
    public static final String CORE_NAMESPACE_NAME = "mule".toUpperCase();
    public static final String ANY_IDENTIFIER = MuleErrors.ANY.name();
    public static final String CRITICAL_IDENTIFIER = MuleErrors.CRITICAL.name();
    private String identifier;
    private String namespace;
    private ErrorType parentErrorType;

    public static ErrorTypeBuilder builder() {
        return new ErrorTypeBuilder();
    }

    private ErrorTypeBuilder() {
    }

    public ErrorTypeBuilder identifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    public ErrorTypeBuilder namespace(String namespace) {
        this.namespace = namespace;
        return this;
    }

    public ErrorTypeBuilder parentErrorType(ErrorType parentErrorType) {
        this.parentErrorType = parentErrorType;
        return this;
    }

    public ErrorType build() {
        Objects.requireNonNull(this.identifier, "string representation cannot be null");
        Objects.requireNonNull(this.namespace, "namespace representation cannot be null");
        if (!this.isRoot()) {
            Objects.requireNonNull(this.parentErrorType, "parent error type cannot be null");
        }
        return new ErrorTypeImplementation(this.identifier, this.namespace, this.parentErrorType);
    }

    private boolean isRoot() {
        return (this.identifier.equals(ANY_IDENTIFIER) || this.identifier.equals(CRITICAL_IDENTIFIER)) && this.namespace.equals(CORE_NAMESPACE_NAME);
    }

    private static final class ErrorTypeImplementation
    implements ErrorType {
        private static final long serialVersionUID = -3716206147606234572L;
        private final String identifier;
        private final String namespace;
        private final ErrorType parentErrorType;
        private final String asString;

        private ErrorTypeImplementation(String identifier, String namespace, ErrorType parentErrorType) {
            this.identifier = identifier;
            this.namespace = namespace;
            this.parentErrorType = parentErrorType;
            this.asString = String.format("%s:%s", namespace, identifier);
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public ErrorType getParentErrorType() {
            return this.parentErrorType;
        }

        public String toString() {
            return this.asString;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ErrorTypeImplementation that = (ErrorTypeImplementation)o;
            return Objects.equals(this.identifier, that.identifier) && Objects.equals(this.namespace, that.namespace) && Objects.equals(this.parentErrorType, that.parentErrorType);
        }

        public int hashCode() {
            return Objects.hash(this.identifier, this.namespace, this.parentErrorType);
        }
    }
}

