/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.routing;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.core.api.config.i18n.CoreMessages;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.tracing.customization.ComponentExecutionInitialSpanInfo;
import org.mule.runtime.core.internal.routing.AbstractForkJoinRouter;
import org.mule.runtime.core.internal.routing.ForkJoinStrategy;
import org.mule.runtime.core.internal.routing.ForkJoinStrategyFactory;
import org.mule.runtime.core.internal.routing.forkjoin.CollectMapForkJoinStrategyFactory;
import org.mule.runtime.core.privileged.processor.Router;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.mule.runtime.core.privileged.profiling.tracing.InitialSpanInfoAware;
import org.mule.runtime.tracer.api.span.info.InitialSpanInfo;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public class ScatterGatherRouter
extends AbstractForkJoinRouter
implements Router {
    private List<MessageProcessorChain> routes = Collections.emptyList();

    @Override
    protected Consumer<CoreEvent> onEvent() {
        return event -> ScatterGatherRouter.validateMessageIsNotConsumable(event.getMessage());
    }

    @Override
    protected Publisher<ForkJoinStrategy.RoutingPair> getRoutingPairs(CoreEvent event) {
        return Flux.fromIterable(this.routes).map(route -> ForkJoinStrategy.RoutingPair.of(event, route));
    }

    protected List<MessageProcessorChain> getOwnedObjects() {
        return this.routes;
    }

    public void setRoutes(List<MessageProcessorChain> routes) {
        this.routes = routes;
        for (MessageProcessorChain route : routes) {
            if (!(route instanceof InitialSpanInfoAware)) continue;
            ((InitialSpanInfoAware)route).setInitialSpanInfo((InitialSpanInfo)new ComponentExecutionInitialSpanInfo((Component)this, ":route"));
        }
    }

    @Override
    protected boolean isDelayErrors() {
        return true;
    }

    @Override
    protected int getDefaultMaxConcurrency() {
        return this.routes.size();
    }

    @Override
    protected ForkJoinStrategyFactory getDefaultForkJoinStrategyFactory() {
        return new CollectMapForkJoinStrategyFactory();
    }

    public static void validateMessageIsNotConsumable(Message message) {
        if (message.getPayload().getDataType().isStreamType()) {
            throw new MuleRuntimeException(CoreMessages.cannotCopyStreamPayload((String)message.getPayload().getDataType().getType().getName()));
        }
    }
}

