/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.license;

import de.schlichtherle.license.IllegalPasswordException;
import de.schlichtherle.license.KeyStoreParam;
import de.schlichtherle.license.LicenseNotaryException;
import de.schlichtherle.license.Policy;
import de.schlichtherle.util.ObfuscatedString;
import de.schlichtherle.xml.GenericCertificate;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;

public class LicenseNotary {
    private static final int BUFSIZE = 5120;
    static final String PARAM = new ObfuscatedString(new long[]{668274362144012114L, -2115765889337599212L}).toString();
    private static final String ALIAS = new ObfuscatedString(new long[]{1112708769776922148L, 6703392504509681290L}).toString();
    private static final String EXC_NO_KEY_PWD = new ObfuscatedString(new long[]{-7210613020960449599L, 222075784786550139L, 9025728610804768010L}).toString();
    private static final String EXC_NO_KEY_ENTRY = new ObfuscatedString(new long[]{-1386002024146642540L, 4133952825992554401L, -8020387964636761861L}).toString();
    private static final String EXC_PRIVATE_KEY_OR_PWD_IS_NOT_ALLOWED = new ObfuscatedString(new long[]{-2960555953270849419L, 3827258740935670554L, -3005417608224527600L, 1939660993088349256L, 4750831951568910874L}).toString();
    private static final String EXC_NO_CERTIFICATE_ENTRY = new ObfuscatedString(new long[]{-3872127676557769698L, -2469202953083814859L, 6713970776812571709L, -482260351456063412L}).toString();
    private static final String SHA1_WITH_DSA = new ObfuscatedString(new long[]{-1509550478491572167L, 1688274905166048601L, -4620167493569680976L}).toString();
    private static final String JKS = new ObfuscatedString(new long[]{-6234396975553918200L, 2370155821952859770L}).toString();
    private KeyStoreParam param;
    private KeyStore keyStore;
    private PrivateKey privateKey;
    private PublicKey publicKey;

    protected LicenseNotary() {
    }

    public LicenseNotary(KeyStoreParam keyStoreParam) throws NullPointerException, IllegalPasswordException {
        this.setKeyStoreParam(keyStoreParam);
    }

    public KeyStoreParam getKeyStoreParam() {
        return this.param;
    }

    public void setKeyStoreParam(KeyStoreParam keyStoreParam) throws NullPointerException, IllegalPasswordException {
        if (keyStoreParam == null) {
            throw new NullPointerException(PARAM);
        }
        if (keyStoreParam.getAlias() == null) {
            throw new NullPointerException(ALIAS);
        }
        Policy policy = Policy.getCurrent();
        String string = keyStoreParam.getStorePwd();
        policy.checkPwd(string);
        String string2 = keyStoreParam.getKeyPwd();
        if (string2 != null) {
            policy.checkPwd(string2);
        }
        this.param = keyStoreParam;
        this.keyStore = null;
        this.privateKey = null;
        this.publicKey = null;
    }

    public GenericCertificate sign(Object object) throws Exception {
        GenericCertificate genericCertificate = new GenericCertificate();
        this.sign(genericCertificate, object);
        return genericCertificate;
    }

    public void sign(GenericCertificate genericCertificate, Object object) throws Exception {
        genericCertificate.sign(object, this.getPrivateKey(), this.getSignatureEngine());
    }

    public void verify(GenericCertificate genericCertificate) throws Exception {
        genericCertificate.verify(this.getPublicKey(), this.getSignatureEngine());
    }

    protected PrivateKey getPrivateKey() throws LicenseNotaryException, IOException, CertificateException, NoSuchAlgorithmException, UnrecoverableKeyException {
        if (this.privateKey == null) {
            KeyStoreParam keyStoreParam = this.getKeyStoreParam();
            String string = keyStoreParam.getKeyPwd();
            String string2 = keyStoreParam.getAlias();
            if (string == null) {
                throw new LicenseNotaryException(EXC_NO_KEY_PWD, string2);
            }
            KeyStore keyStore = this.getKeyStore();
            try {
                this.privateKey = (PrivateKey)keyStore.getKey(string2, string.toCharArray());
            }
            catch (KeyStoreException keyStoreException) {
                throw new AssertionError((Object)keyStoreException);
            }
            if (this.privateKey == null) {
                throw new LicenseNotaryException(EXC_NO_KEY_ENTRY, string2);
            }
        }
        return this.privateKey;
    }

    protected PublicKey getPublicKey() throws LicenseNotaryException, IOException, CertificateException, NoSuchAlgorithmException {
        if (this.publicKey == null) {
            String string = this.getKeyStoreParam().getAlias();
            KeyStore keyStore = this.getKeyStore();
            try {
                if (this.getKeyStoreParam().getKeyPwd() != null != keyStore.isKeyEntry(string)) {
                    throw new LicenseNotaryException(EXC_PRIVATE_KEY_OR_PWD_IS_NOT_ALLOWED, string);
                }
                Certificate certificate = keyStore.getCertificate(string);
                if (certificate == null) {
                    throw new LicenseNotaryException(EXC_NO_CERTIFICATE_ENTRY, string);
                }
                this.publicKey = certificate.getPublicKey();
            }
            catch (KeyStoreException keyStoreException) {
                throw new AssertionError((Object)keyStoreException);
            }
        }
        return this.publicKey;
    }

    protected Signature getSignatureEngine() {
        try {
            return Signature.getInstance(SHA1_WITH_DSA);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError((Object)noSuchAlgorithmException);
        }
    }

    protected KeyStore getKeyStore() throws IOException, CertificateException, NoSuchAlgorithmException {
        if (this.keyStore != null) {
            return this.keyStore;
        }
        InputStream inputStream = null;
        try {
            this.keyStore = KeyStore.getInstance(JKS);
            inputStream = new BufferedInputStream(this.param.getStream(), 5120);
            this.keyStore.load(inputStream, this.getKeyStoreParam().getStorePwd().toCharArray());
        }
        catch (KeyStoreException keyStoreException) {
            throw new AssertionError((Object)keyStoreException);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
        }
        return this.keyStore;
    }
}

