/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.api.tracing.customization;

import java.util.function.BiConsumer;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.core.api.tracing.customization.SpanInitialInfoUtils;
import org.mule.runtime.tracer.api.span.info.InitialExportInfo;
import org.mule.runtime.tracer.api.span.info.InitialSpanInfo;

public class ComponentExecutionInitialSpanInfo
implements InitialSpanInfo {
    public static final String LOCATION_KEY = "location";
    public static final int INITIAL_ATTRIBUTES_BASE_COUNT = 1;
    public static final String EXECUTE_NEXT = "execute-next";
    public static final String FLOW = "flow";
    protected final Component component;
    private final String name;
    private final boolean isPolicySpan;
    private final boolean rootSpan;

    public ComponentExecutionInitialSpanInfo(Component component, String spanNameSuffix) {
        this.component = component;
        this.name = SpanInitialInfoUtils.getSpanName(component.getIdentifier()) + spanNameSuffix;
        this.isPolicySpan = this.isComponentOfName(component, EXECUTE_NEXT);
        this.rootSpan = this.isComponentOfName(component, FLOW);
    }

    public ComponentExecutionInitialSpanInfo(Component component) {
        this(component, "");
    }

    public void forEachAttribute(BiConsumer<String, String> biConsumer) {
        biConsumer.accept(LOCATION_KEY, SpanInitialInfoUtils.getLocationAsString(this.component.getLocation()));
    }

    public int getInitialAttributesCount() {
        return 1;
    }

    public String getName() {
        return this.name;
    }

    public InitialExportInfo getInitialExportInfo() {
        return InitialExportInfo.DEFAULT_EXPORT_SPAN_CUSTOMIZATION_INFO;
    }

    public boolean isPolicySpan() {
        return this.isPolicySpan;
    }

    public boolean isRootSpan() {
        return this.rootSpan;
    }

    private boolean isComponentOfName(Component component, String name) {
        return component.getIdentifier() != null && name.equals(component.getIdentifier().getName());
    }
}

