/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.profiling.producer;

import java.util.function.Function;
import org.mule.runtime.api.profiling.ProfilingProducerScope;
import org.mule.runtime.api.profiling.threading.ThreadSnapshotCollector;
import org.mule.runtime.api.profiling.type.ProfilingEventType;
import org.mule.runtime.api.profiling.type.context.ComponentThreadingProfilingEventContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.internal.profiling.DefaultProfilingService;
import org.mule.runtime.core.internal.profiling.ResettableProfilingDataProducer;
import org.mule.runtime.feature.internal.config.profiling.ProfilingDataProducerStatus;
import org.mule.runtime.feature.internal.config.profiling.ProfilingFeatureFlaggingService;

public class ComponentThreadingProfilingDataProducer
implements ResettableProfilingDataProducer<ComponentThreadingProfilingEventContext, CoreEvent> {
    private final DefaultProfilingService defaultProfilingService;
    private final ProfilingEventType<ComponentThreadingProfilingEventContext> profilingEventType;
    private final ThreadSnapshotCollector threadSnapshotCollector;
    private ProfilingDataProducerStatus profilingProducerStatus;

    public ComponentThreadingProfilingDataProducer(DefaultProfilingService defaultProfilingService, ProfilingEventType<ComponentThreadingProfilingEventContext> profilingEventType, ThreadSnapshotCollector threadSnapshotCollector, ProfilingProducerScope profilingProducerContext, ProfilingFeatureFlaggingService featureFlaggingService) {
        this.defaultProfilingService = defaultProfilingService;
        this.profilingEventType = profilingEventType;
        this.threadSnapshotCollector = threadSnapshotCollector;
        this.profilingProducerStatus = featureFlaggingService.getProfilingDataProducerStatus(profilingEventType, profilingProducerContext);
    }

    public void triggerProfilingEvent(ComponentThreadingProfilingEventContext eventContext) {
        if (this.profilingProducerStatus.isEnabled()) {
            eventContext.setThreadSnapshot(this.threadSnapshotCollector.getCurrentThreadSnapshot());
            this.defaultProfilingService.notifyEvent(eventContext, this.profilingEventType);
        }
    }

    public void triggerProfilingEvent(CoreEvent sourceData, Function<CoreEvent, ComponentThreadingProfilingEventContext> transformation) {
        if (this.profilingProducerStatus.isEnabled()) {
            ComponentThreadingProfilingEventContext eventContext = transformation.apply(sourceData);
            eventContext.setThreadSnapshot(this.threadSnapshotCollector.getCurrentThreadSnapshot());
            this.defaultProfilingService.notifyEvent(eventContext, this.profilingEventType);
        }
    }

    @Override
    public void reset() {
        this.profilingProducerStatus.reset();
    }
}

