/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.privileged.processor.chain;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import org.mule.api.annotation.NoExtend;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.exception.FlowExceptionHandler;
import org.mule.runtime.core.api.exception.NullExceptionHandler;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.processor.HasLocation;
import org.mule.runtime.core.api.processor.InterceptingMessageProcessor;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.strategy.ProcessingStrategy;
import org.mule.runtime.core.internal.processor.strategy.BlockingProcessingStrategyFactory;
import org.mule.runtime.core.privileged.processor.MessageProcessorBuilder;
import org.mule.runtime.core.privileged.processor.chain.AbstractMessageProcessorChain;
import org.mule.runtime.core.privileged.processor.chain.AbstractMessageProcessorChainBuilder;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.mule.runtime.core.privileged.profiling.tracing.InitialSpanInfoAware;
import org.mule.runtime.tracer.api.span.info.InitialSpanInfo;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NoExtend
public class DefaultMessageProcessorChainBuilder
extends AbstractMessageProcessorChainBuilder
implements InitialSpanInfoAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultMessageProcessorChainBuilder.class);

    @Override
    public MessageProcessorChain build() {
        LinkedList<Processor> tempList = new LinkedList<Processor>();
        LinkedList<Processor> processorsForLifecycle = new LinkedList<Processor>();
        boolean atLeastOneIntercepting = false;
        for (int i = this.processors.size() - 1; i >= 0; --i) {
            Processor processor = this.initializeMessageProcessor(this.processors.get(i));
            if (processor instanceof InterceptingMessageProcessor) {
                atLeastOneIntercepting = true;
                InterceptingMessageProcessor interceptingProcessor = (InterceptingMessageProcessor)processor;
                if (i + 1 < this.processors.size()) {
                    MessageProcessorChain innerChain = this.createSimpleInterceptedChain(tempList, interceptingProcessor.isBlocking() ? Optional.of(BlockingProcessingStrategyFactory.BLOCKING_PROCESSING_STRATEGY_INSTANCE) : Optional.ofNullable(this.processingStrategy));
                    processorsForLifecycle.addFirst(innerChain);
                    interceptingProcessor.setListener(innerChain);
                }
                tempList = new LinkedList<Processor>(Collections.singletonList(processor));
                continue;
            }
            tempList.addFirst(processor);
        }
        if (atLeastOneIntercepting) {
            MessageProcessorChain head = this.createSimpleChain(tempList, Optional.ofNullable(this.processingStrategy));
            processorsForLifecycle.addFirst(head);
            return this.createInterceptingChain(head, this.processors, processorsForLifecycle);
        }
        return this.createSimpleChain(tempList, Optional.ofNullable(this.processingStrategy));
    }

    protected MessageProcessorChain createSimpleChain(List<Processor> tempList, Optional<ProcessingStrategy> processingStrategyOptional) {
        if (tempList.size() == 1 && tempList.get(0) instanceof DefaultMessageProcessorChain) {
            DefaultMessageProcessorChain messageProcessorChain = (DefaultMessageProcessorChain)tempList.get(0);
            if (this.chainInitialSpanInfo != null) {
                messageProcessorChain.setInitialSpanInfo(this.chainInitialSpanInfo);
            }
            return messageProcessorChain;
        }
        DefaultMessageProcessorChain messageProcessorChain = new DefaultMessageProcessorChain(this.name != null ? "(chain) of " + this.name : "(chain)", processingStrategyOptional, new ArrayList<Processor>(tempList), this.messagingExceptionHandler, this.location);
        if (this.chainInitialSpanInfo != null) {
            messageProcessorChain.setInitialSpanInfo(this.chainInitialSpanInfo);
        }
        return messageProcessorChain;
    }

    private MessageProcessorChain createSimpleInterceptedChain(List<Processor> tempList, Optional<ProcessingStrategy> processingStrategyOptional) {
        if (tempList.size() == 1 && tempList.get(0) instanceof DefaultMessageProcessorChain) {
            DefaultMessageProcessorChain messageProcessorChain = (DefaultMessageProcessorChain)tempList.get(0);
            if (this.chainInitialSpanInfo != null) {
                messageProcessorChain.setInitialSpanInfo(this.chainInitialSpanInfo);
            }
            return messageProcessorChain;
        }
        DefaultMessageProcessorChain messageProcessorChain = new DefaultMessageProcessorChain(this.name != null ? "(chain) of " + this.name : "(chain)", processingStrategyOptional, new ArrayList<Processor>(tempList), NullExceptionHandler.getInstance(), this.location);
        if (this.chainInitialSpanInfo != null) {
            messageProcessorChain.setInitialSpanInfo(this.chainInitialSpanInfo);
        }
        return messageProcessorChain;
    }

    protected MessageProcessorChain createInterceptingChain(Processor head, List<Processor> processors, List<Processor> processorsForLifecycle) {
        InterceptingMessageProcessorChain messageProcessorChain = new InterceptingMessageProcessorChain(this.name != null ? "(intercepting chain) of " + this.name : "(intercepting chain)", Optional.ofNullable(this.processingStrategy), head, processors, processorsForLifecycle, NullExceptionHandler.getInstance(), this.location);
        if (this.chainInitialSpanInfo != null) {
            messageProcessorChain.setInitialSpanInfo(this.chainInitialSpanInfo);
        }
        return messageProcessorChain;
    }

    @Override
    public DefaultMessageProcessorChainBuilder chain(Processor ... processors) {
        for (Processor messageProcessor : processors) {
            this.processors.add(messageProcessor);
        }
        return this;
    }

    public DefaultMessageProcessorChainBuilder chain(List<Processor> processors) {
        if (processors != null) {
            this.processors.addAll(processors);
        }
        return this;
    }

    @Override
    public DefaultMessageProcessorChainBuilder chain(MessageProcessorBuilder ... builders) {
        for (MessageProcessorBuilder messageProcessorBuilder : builders) {
            this.processors.add(messageProcessorBuilder);
        }
        return this;
    }

    public DefaultMessageProcessorChainBuilder chainBefore(Processor processor) {
        this.processors.add(0, processor);
        return this;
    }

    public DefaultMessageProcessorChainBuilder chainBefore(MessageProcessorBuilder builder) {
        this.processors.add(0, builder);
        return this;
    }

    @Override
    public void setInitialSpanInfo(InitialSpanInfo initialSpanInfo) {
        this.chainInitialSpanInfo = initialSpanInfo;
    }

    public static MessageProcessorChain newLazyProcessorChainBuilder(AbstractMessageProcessorChainBuilder chainBuilder, MuleContext muleContext, Supplier<ProcessingStrategy> processingStrategySupplier) {
        return new LazyProcessorChainBuilder(chainBuilder.name, Optional.empty(), chainBuilder.processors, chainBuilder, processingStrategySupplier);
    }

    private static final class LazyProcessorChainBuilder
    extends AbstractMessageProcessorChain
    implements MessagingExceptionHandlerAware,
    InitialSpanInfoAware {
        private final AbstractMessageProcessorChainBuilder chainBuilder;
        private final Supplier<ProcessingStrategy> processingStrategySupplier;
        private FlowExceptionHandler messagingExceptionHandler;
        private MessageProcessorChain delegate;
        private InitialSpanInfo chainInitialSpanInfo;

        private LazyProcessorChainBuilder(String name, Optional<ProcessingStrategy> processingStrategyOptional, List<Processor> processors, AbstractMessageProcessorChainBuilder chainBuilder, Supplier<ProcessingStrategy> processingStrategySupplier) {
            super(name, processingStrategyOptional, processors, null);
            this.chainBuilder = chainBuilder;
            this.processingStrategySupplier = processingStrategySupplier;
        }

        @Override
        public void initialise() throws InitialisationException {
            this.chainBuilder.setProcessingStrategy(this.processingStrategySupplier.get());
            this.chainBuilder.setMessagingExceptionHandler(this.messagingExceptionHandler);
            this.chainBuilder.setChainInitialSpanInfo(this.chainInitialSpanInfo);
            this.delegate = this.chainBuilder.build();
            this.delegate.setAnnotations(this.getAnnotations());
            LifecycleUtils.initialiseIfNeeded(this.delegate, this.muleContext);
        }

        @Override
        public void start() throws MuleException {
            LifecycleUtils.startIfNeeded(this.delegate);
        }

        @Override
        public void dispose() {
            LifecycleUtils.disposeIfNeeded(this.delegate, LOGGER);
        }

        @Override
        public void stop() throws MuleException {
            LifecycleUtils.stopIfNeeded(this.delegate);
        }

        @Override
        public CoreEvent process(CoreEvent event) throws MuleException {
            return this.delegate.process(event);
        }

        @Override
        public Publisher<CoreEvent> apply(Publisher<CoreEvent> publisher) {
            return this.delegate.apply(publisher);
        }

        @Override
        public void setMessagingExceptionHandler(FlowExceptionHandler messagingExceptionHandler) {
            this.messagingExceptionHandler = messagingExceptionHandler;
        }

        @Override
        public void setInitialSpanInfo(InitialSpanInfo chainInitialSpanInfo) {
            this.chainInitialSpanInfo = chainInitialSpanInfo;
        }
    }

    public static interface MessagingExceptionHandlerAware {
        public void setMessagingExceptionHandler(FlowExceptionHandler var1);
    }

    static class InterceptingMessageProcessorChain
    extends AbstractMessageProcessorChain
    implements HasLocation {
        private final Processor head;
        private final List<Processor> processorsForLifecycle;
        private final ComponentLocation pipeLineLocation;

        protected InterceptingMessageProcessorChain(String name, Optional<ProcessingStrategy> processingStrategyOptional, Processor head, List<Processor> processors, List<Processor> processorsForLifecycle, FlowExceptionHandler messagingExceptionHandler) {
            this(name, processingStrategyOptional, head, processors, processorsForLifecycle, messagingExceptionHandler, null);
        }

        protected InterceptingMessageProcessorChain(String name, Optional<ProcessingStrategy> processingStrategyOptional, Processor head, List<Processor> processors, List<Processor> processorsForLifecycle, FlowExceptionHandler messagingExceptionHandler, ComponentLocation pipeLineLocation) {
            super(name, processingStrategyOptional, processors, messagingExceptionHandler);
            this.head = head;
            this.processorsForLifecycle = processorsForLifecycle;
            this.pipeLineLocation = pipeLineLocation;
        }

        @Override
        protected List<Processor> getMessageProcessorsForLifecycle() {
            return this.processorsForLifecycle;
        }

        @Override
        protected List<Processor> getProcessorsToExecute() {
            return Collections.singletonList(this.head);
        }

        @Override
        public ComponentLocation resolveLocation() {
            return this.pipeLineLocation;
        }
    }

    @NoExtend
    protected static class DefaultMessageProcessorChain
    extends AbstractMessageProcessorChain
    implements HasLocation {
        private ComponentLocation pipeLineLocation;

        protected DefaultMessageProcessorChain(String name, Optional<ProcessingStrategy> processingStrategyOptional, List<Processor> processors, FlowExceptionHandler messagingExceptionHandler) {
            this(name, processingStrategyOptional, processors, messagingExceptionHandler, null);
        }

        protected DefaultMessageProcessorChain(String name, Optional<ProcessingStrategy> processingStrategyOptional, List<Processor> processors, FlowExceptionHandler messagingExceptionHandler, ComponentLocation pipeLineLocation) {
            super(name, processingStrategyOptional, processors, messagingExceptionHandler);
            this.pipeLineLocation = pipeLineLocation;
        }

        @Deprecated
        protected DefaultMessageProcessorChain(String name, Optional<ProcessingStrategy> processingStrategyOptional, Processor head, List<Processor> processors, List<Processor> processorsForLifecycle) {
            super(name, processingStrategyOptional, processors, (exception, event) -> null);
        }

        @Override
        public ComponentLocation resolveLocation() {
            return this.pipeLineLocation;
        }
    }
}

