/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.tracer.impl.exporter;

import io.opentelemetry.sdk.trace.SpanProcessor;
import javax.inject.Inject;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.tracer.api.sniffer.ExportedSpanSniffer;
import org.mule.runtime.tracer.api.sniffer.SpanSnifferManager;
import org.mule.runtime.tracer.api.span.InternalSpan;
import org.mule.runtime.tracer.api.span.exporter.SpanExporter;
import org.mule.runtime.tracer.api.span.info.InitialSpanInfo;
import org.mule.runtime.tracer.exporter.api.SpanExporterFactory;
import org.mule.runtime.tracer.exporter.api.config.SpanExporterConfiguration;
import org.mule.runtime.tracer.impl.exporter.OpenTelemetrySpanExporter;
import org.mule.runtime.tracer.impl.exporter.optel.resources.OpenTelemetryResources;

public class OpenTelemetrySpanExporterFactory
implements SpanExporterFactory {
    @Inject
    SpanExporterConfiguration configuration;
    @Inject
    MuleContext muleContext;
    private SpanProcessor spanProcessor;

    public SpanExporter getSpanExporter(InternalSpan internalSpan, InitialSpanInfo initialExportInfo) {
        return OpenTelemetrySpanExporter.builder().withStartSpanInfo(initialExportInfo).withArtifactId(this.muleContext.getConfiguration().getId()).withArtifactType(this.muleContext.getArtifactType().getAsString()).withSpanProcessor(this.getSpanProcessor()).withInternalSpan(internalSpan).build();
    }

    private SpanProcessor getSpanProcessor() {
        if (this.spanProcessor == null) {
            this.spanProcessor = OpenTelemetryResources.resolveExporterProcessor(this.configuration);
        }
        return this.spanProcessor;
    }

    public SpanSnifferManager getSpanExporterManager() {
        return new OpenTelemetrySpanExporterManager();
    }

    private static class OpenTelemetrySpanExporterManager
    implements SpanSnifferManager {
        private OpenTelemetrySpanExporterManager() {
        }

        public ExportedSpanSniffer getExportedSpanSniffer() {
            return OpenTelemetryResources.getNewExportedSpanCapturer();
        }
    }
}

