/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.tracer.impl.exporter.capturer;

import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.trace.data.EventData;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.mule.runtime.tracer.api.sniffer.CapturedEventData;
import org.mule.runtime.tracer.api.sniffer.CapturedExportedSpan;
import org.mule.runtime.tracer.api.sniffer.ExportedSpanSniffer;
import org.mule.runtime.tracer.impl.exporter.optel.resources.OpenTelemetryResources;

public class CapturingSpanExporterWrapper
implements SpanExporter {
    private final SpanExporter delegate;
    private Set<MuleSpanSniffer> spanCapturers = ConcurrentHashMap.newKeySet();

    public CapturingSpanExporterWrapper(SpanExporter delegate) {
        this.delegate = delegate;
    }

    public CompletableResultCode export(Collection<SpanData> collection) {
        if (!this.spanCapturers.isEmpty()) {
            this.spanCapturers.forEach(capturer -> capturer.addSpans(collection));
        }
        return this.delegate.export(collection);
    }

    public CompletableResultCode flush() {
        return this.delegate.flush();
    }

    public CompletableResultCode shutdown() {
        return this.delegate.shutdown();
    }

    public ExportedSpanSniffer getSpanCapturer() {
        MuleSpanSniffer spanCapturer = new MuleSpanSniffer(this);
        this.spanCapturers.add(spanCapturer);
        return spanCapturer;
    }

    private void dispose(ExportedSpanSniffer muleSpanCapturer) {
        this.spanCapturers.remove(muleSpanCapturer);
    }

    private static final class MuleSpanSniffer
    implements ExportedSpanSniffer {
        private final CapturingSpanExporterWrapper muleOtlpGrpcSpanExporter;
        private Set<SpanData> spanData = ConcurrentHashMap.newKeySet();

        public MuleSpanSniffer(CapturingSpanExporterWrapper muleOtlpGrpcSpanExporter) {
            this.muleOtlpGrpcSpanExporter = muleOtlpGrpcSpanExporter;
        }

        public void addSpans(Collection<SpanData> spanItems) {
            this.spanData.addAll(spanItems);
        }

        public Collection<CapturedExportedSpan> getExportedSpans() {
            ArrayList<CapturedExportedSpan> exportedSpans = new ArrayList<CapturedExportedSpan>();
            for (SpanData spanData : this.spanData) {
                exportedSpans.add(new SpanDataWrapper(spanData));
            }
            return exportedSpans;
        }

        public void dispose() {
            this.muleOtlpGrpcSpanExporter.dispose(this);
        }

        private static final class OpenTelemetryEventDataWrapper
        implements CapturedEventData {
            private final EventData eventData;

            public OpenTelemetryEventDataWrapper(EventData eventData) {
                this.eventData = eventData;
            }

            public String getName() {
                return this.eventData.getName();
            }

            public Map<String, Object> getAttributes() {
                HashMap<String, Object> events = new HashMap<String, Object>();
                this.eventData.getAttributes().asMap().forEach((attributeKey, attributeValue) -> events.put(attributeKey.getKey(), String.valueOf(attributeValue)));
                return events;
            }
        }

        private static final class SpanDataWrapper
        implements CapturedExportedSpan {
            public static final String EXCEPTION_EVENT_NAME = "exception";
            private final SpanData spanData;

            public SpanDataWrapper(SpanData spanData) {
                this.spanData = spanData;
            }

            public String getName() {
                return this.spanData.getName();
            }

            public String getParentSpanId() {
                return this.spanData.getParentSpanId();
            }

            public String getSpanId() {
                return this.spanData.getSpanId();
            }

            public String getTraceId() {
                return this.spanData.getTraceId();
            }

            public Map<String, String> getAttributes() {
                HashMap<String, String> attributes = new HashMap<String, String>();
                this.spanData.getAttributes().asMap().forEach((k, v) -> attributes.put(k.getKey(), String.valueOf(v)));
                return attributes;
            }

            public List<CapturedEventData> getEvents() {
                return this.spanData.getEvents().stream().map(OpenTelemetryEventDataWrapper::new).collect(Collectors.toList());
            }

            public String getSpanKindName() {
                return this.spanData.getKind().name();
            }

            public String getServiceName() {
                return (String)this.spanData.getResource().getAttribute(OpenTelemetryResources.SERVICE_NAME_KEY);
            }

            public String toString() {
                return String.format("a span with name: [%s], ID: [%s] and parent Span ID: [%s]", this.getName(), this.getSpanId(), this.getParentSpanId());
            }

            public boolean hasErrorStatus() {
                return this.spanData.getStatus().getStatusCode().equals((Object)StatusCode.ERROR);
            }

            public long getStartEpochSpanNanos() {
                return this.spanData.getStartEpochNanos();
            }

            public long getEndSpanEpochNanos() {
                return this.spanData.getEndEpochNanos();
            }
        }
    }
}

