/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.external.handlers.action;

import com.google.inject.Inject;
import com.mulesoft.agent.domain.action.ServerAction;
import com.mulesoft.agent.exception.AgentEnableOperationException;
import com.mulesoft.agent.exception.RuntimeRestartException;
import com.mulesoft.agent.exception.RuntimeShutdownException;
import com.mulesoft.agent.external.handlers.ConfigurableExternalHandler;
import com.mulesoft.agent.services.ActionService;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Named(value="action.request.handler")
@Path(value="actions")
@Singleton
public class ActionRequestHandler
extends ConfigurableExternalHandler {
    private static final String ERROR_MESSAGE_FORMAT = "{\"errorType\": \"%s\", \"errorMessage\": \"%s.\" }";
    @Inject
    private ActionService actionService;

    public void enable(boolean state) throws AgentEnableOperationException {
        this.enabledSwitch.switchTo(state);
    }

    public boolean isEnabled() {
        return this.enabledSwitch.isEnabled();
    }

    @PUT
    @Produces(value={"application/json"})
    public Response performRuntimeAction(ServerAction serverAction) {
        if (serverAction.getActionType() == null) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)String.format(ERROR_MESSAGE_FORMAT, Response.Status.BAD_REQUEST.getReasonPhrase(), "Action Type is missing")).build();
        }
        try {
            this.actionService.performAction(serverAction);
        }
        catch (RuntimeRestartException | RuntimeShutdownException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)String.format(ERROR_MESSAGE_FORMAT, e.getClass().getName(), e.getMessage())).build();
        }
        return Response.status((Response.Status)Response.Status.ACCEPTED).build();
    }
}

