/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.external.handlers.clustering;

import com.google.inject.Inject;
import com.mulesoft.agent.domain.cluster.ClusterMembership;
import com.mulesoft.agent.exception.AgentClusteringException;
import com.mulesoft.agent.exception.AgentEnableOperationException;
import com.mulesoft.agent.external.handlers.ConfigurableExternalHandler;
import com.mulesoft.agent.services.ClusteringService;
import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Named(value="clustering.request.handler")
@Path(value="clusters")
@Singleton
public class ClusteringRequestHandler
extends ConfigurableExternalHandler {
    @Inject
    private ClusteringService clusteringService;

    public void enable(boolean state) throws AgentEnableOperationException {
        this.enabledSwitch.switchTo(state);
    }

    public boolean isEnabled() {
        return this.enabledSwitch.isEnabled();
    }

    @GET
    @Produces(value={"application/json"})
    public Response getClusterMembership() {
        try {
            if (this.clusteringService.isClustered()) {
                ClusterMembership clusterMembership = this.clusteringService.getClusterMembership();
                return Response.status((Response.Status)Response.Status.OK).entity((Object)clusterMembership).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"{\"errorType\":\"ServerNotClustered\", \"errorMessage\":\"The server is not part of a cluster\" }").build();
        }
        catch (AgentClusteringException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("{\"errorType\":\"" + ((Object)((Object)e)).getClass() + "\", \"errorMessage\":\"" + e.getMessage() + "\" }")).build();
        }
    }

    @GET
    @Path(value="members")
    @Produces(value={"application/json"})
    public Response getClusterMembers() {
        try {
            if (this.clusteringService.isClustered()) {
                List clusterMembers = this.clusteringService.getCurrentClusterMembers();
                return Response.status((Response.Status)Response.Status.OK).entity((Object)clusterMembers).build();
            }
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"{\"errorType\":\"ServerNotClustered\", \"errorMessage\":\"The server is not part of a cluster\" }").build();
        }
        catch (AgentClusteringException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("{\"errorType\":\"" + ((Object)((Object)e)).getClass() + "\", \"errorMessage\":\"" + e.getMessage() + "\" }")).build();
        }
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response addToCluster(ClusterMembership clusterMembership) {
        try {
            this.clusteringService.addToCluster(clusterMembership);
            return Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)clusterMembership).build();
        }
        catch (IllegalArgumentException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("{\"errorType\":\"" + e.getClass() + "\", \"errorMessage\":\"" + e.getMessage() + "\" }")).build();
        }
        catch (AgentClusteringException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("{\"errorType\":\"" + ((Object)((Object)e)).getClass() + "\", \"errorMessage\":\"" + e.getMessage() + "\" }")).build();
        }
    }

    @DELETE
    @Produces(value={"application/json"})
    public Response removeFromCluster() {
        try {
            this.clusteringService.removeFromCluster();
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        }
        catch (AgentClusteringException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("{\"errorType\":\"" + ((Object)((Object)e)).getClass() + "\", \"errorMessage\":\"" + e.getMessage() + "\" }")).build();
        }
        catch (UnsupportedOperationException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("{\"errorType\":\"" + e.getClass() + "\", \"errorMessage\":\"" + e.getMessage() + "\" }")).build();
        }
    }
}

