/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.core.internal.streaming.bytes;

import com.mulesoft.mule.runtime.core.internal.streaming.bytes.FileStoreInputStreamBuffer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.function.Supplier;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.core.api.streaming.bytes.ByteBufferManager;
import org.mule.runtime.core.api.streaming.bytes.FileStoreCursorStreamConfig;

public class ImmutableFileStoreInputStreamBuffer
extends FileStoreInputStreamBuffer {
    private final Supplier<File> fileSupplier;

    public ImmutableFileStoreInputStreamBuffer(InputStream inputStream, Supplier<File> fileSupplier, FileStoreCursorStreamConfig config, ByteBufferManager bufferManager) {
        super(inputStream, config, bufferManager);
        this.fileSupplier = fileSupplier;
    }

    @Override
    protected LazyValue<Pair<File, RandomAccessFile>> createFileStore() {
        return new LazyValue(() -> {
            File file = this.fileSupplier.get();
            try {
                return new Pair((Object)file, (Object)new RandomAccessFile(file, "r"));
            }
            catch (FileNotFoundException e) {
                throw new IllegalArgumentException(String.format("Stream file '%s' does not exists. Verify it wasn't deleted by some other process", file.getAbsolutePath()), e);
            }
        });
    }

    @Override
    protected void write(RandomAccessFile fileStore, ByteBuffer b, int len) throws IOException {
    }

    @Override
    protected void deleteBufferFile(File bufferFile) {
    }
}

