/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.batch.internal;

import com.mulesoft.mule.runtime.module.batch.BatchStepAggregator;
import com.mulesoft.mule.runtime.module.batch.api.record.Record;
import com.mulesoft.mule.runtime.module.batch.engine.BatchEngine;
import com.mulesoft.mule.runtime.module.batch.engine.BatchJobInstanceAdapter;
import com.mulesoft.mule.runtime.module.batch.engine.BatchStepAdapter;
import com.mulesoft.mule.runtime.module.batch.engine.transaction.BatchTransactionContext;
import com.mulesoft.mule.runtime.module.batch.internal.engine.buffer.AggregatorRecordBuffer;
import com.mulesoft.mule.runtime.module.batch.internal.engine.buffer.FixedAggregatorRecordBuffer;
import com.mulesoft.mule.runtime.module.batch.internal.engine.buffer.FixedAggregatorTransactionRecordBuffer;
import com.mulesoft.mule.runtime.module.batch.internal.engine.buffer.StreamingAggregatorBuffer;
import com.mulesoft.mule.runtime.module.batch.reporting.StepExceptionReporter;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.locks.Lock;
import javax.inject.Inject;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ConfigurationComponentLocator;
import org.mule.runtime.api.config.Feature;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.config.MuleRuntimeFeature;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.notification.NotificationDispatcher;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.AbstractMessageProcessorOwner;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.tracing.customization.FixedComponentCoreExecutionInitialSpanInfo;
import org.mule.runtime.core.internal.profiling.InternalProfilingService;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.mule.runtime.core.privileged.processor.chain.MessageProcessorChain;
import org.mule.runtime.tracer.api.EventTracer;
import org.mule.runtime.tracer.api.span.info.InitialSpanInfo;

public class DefaultBatchStepAggregator
extends AbstractMessageProcessorOwner
implements BatchStepAggregator {
    private Integer size = null;
    private boolean streaming = false;
    private boolean preserveMimeTypes = false;
    private BatchStepAdapter step;
    private MessageProcessorChain messageProcessorChain = MessageProcessors.newChain(Optional.empty(), Collections.emptyList(), (InitialSpanInfo)new FixedComponentCoreExecutionInitialSpanInfo((Component)this, "batch-aggregator"));
    private BatchEngine batchEngine;
    private AggregatorRecordBuffer buffer;
    private StepExceptionReporter exceptionReporter;
    @Inject
    private FeatureFlaggingService featureFlaggingService;
    @Inject
    private NotificationDispatcher notificationDispatcher;
    private List<Processor> messageProcessors;
    @Inject
    private InternalProfilingService internalProfilingService;

    public void initialise() throws InitialisationException {
        this.messageProcessorChain = MessageProcessors.newChain((Optional)MessageProcessors.getProcessingStrategy((ConfigurationComponentLocator)this.locator, (Component)this), this.messageProcessors, (InitialSpanInfo)new FixedComponentCoreExecutionInitialSpanInfo((Component)this, "batch-aggregator"));
        super.initialise();
        if (this.step == null) {
            throw new IllegalArgumentException("step cannot be null");
        }
        this.messageProcessorChain.setMuleContext(this.muleContext);
        if (this.streaming) {
            if (this.size != null) {
                throw new IllegalArgumentException(String.format("Aggregator for step %s is in invalid state: Cannot set size if streaming is 'true'", this.step.getName()));
            }
            this.buffer = new StreamingAggregatorBuffer(this.batchEngine, this.step, (Processor)this.messageProcessorChain, this.notificationDispatcher, this.muleContext, (EventTracer<CoreEvent>)this.internalProfilingService.getCoreEventTracer());
        } else {
            if (this.size == null || this.size <= 1) {
                throw new IllegalArgumentException("Step aggregator size needs to be greater than one when streaming is off. If you want to process in batches of one use a regular step instead");
            }
            this.buffer = this.featureFlaggingService.isEnabled((Feature)MuleRuntimeFeature.BATCH_FIXED_AGGREGATOR_TRANSACTION_RECORD_BUFFER) ? new FixedAggregatorTransactionRecordBuffer(this.size, this.preserveMimeTypes, this.batchEngine, this.step, (Processor)this.messageProcessorChain, this.getLocation(), this.notificationDispatcher, this.muleContext, (EventTracer<CoreEvent>)this.internalProfilingService.getCoreEventTracer()) : new FixedAggregatorRecordBuffer(this.size, this.preserveMimeTypes, this.batchEngine, this.step, (Processor)this.messageProcessorChain, this.getLocation(), this.notificationDispatcher, this.muleContext, (EventTracer<CoreEvent>)this.internalProfilingService.getCoreEventTracer());
        }
        this.buffer.setExceptionReporter(this.exceptionReporter);
    }

    @Override
    public void flush(BatchJobInstanceAdapter jobInstance) {
        Lock lock = this.batchEngine.getLock(jobInstance);
        lock.lock();
        try {
            this.buffer.flushAndForget(jobInstance);
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void releaseResources(BatchJobInstanceAdapter jobInstance) {
        this.buffer.forget(jobInstance);
    }

    @Override
    public int add(Record record, BatchTransactionContext ctx) {
        return this.buffer.add(ctx.getJobInstance(), ctx, record);
    }

    @Override
    public long size(BatchJobInstanceAdapter jobInstance) {
        return this.buffer.size(jobInstance);
    }

    protected List<Processor> getOwnedMessageProcessors() {
        return Collections.singletonList(this.messageProcessorChain);
    }

    public void setMessageProcessors(List<Processor> messageProcessors) {
        this.messageProcessors = messageProcessors;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    @Override
    public boolean isStreaming() {
        return this.streaming;
    }

    public void setStreaming(boolean streaming) {
        this.streaming = streaming;
    }

    public void setPreserveMimeTypes(boolean preserveMimeTypes) {
        this.preserveMimeTypes = preserveMimeTypes;
    }

    @Override
    public Integer getSize() {
        return this.size;
    }

    public void setStep(BatchStepAdapter step) {
        this.step = step;
    }

    public void setBatchEngine(BatchEngine batchEngine) {
        this.batchEngine = batchEngine;
    }

    @Override
    public void setExceptionReporter(StepExceptionReporter exceptionReporter) {
        this.exceptionReporter = exceptionReporter;
        if (this.buffer != null) {
            this.buffer.setExceptionReporter(exceptionReporter);
        }
    }

    public void setNotificationDispatcher(NotificationDispatcher notificationDispatcher) {
        this.notificationDispatcher = notificationDispatcher;
    }
}

