/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.session.filter;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.parameter.ValueProviderModel;
import org.mule.runtime.api.value.Value;
import org.mule.runtime.app.declaration.api.ParameterizedElementDeclaration;
import org.mule.runtime.module.tooling.internal.artifact.params.ParameterSimpleValueExtractor;
import org.mule.tooling.client.internal.session.filter.FilterUtils;
import org.mule.tooling.client.internal.session.filter.exception.MissingLevelException;
import org.mule.tooling.client.internal.session.filter.exception.UnknownLevelValueException;

public class ValueFilter {
    public Set<Value> filter(ValueProviderModel valueProviderModel, ParameterizedModel parameterizedModel, ParameterizedElementDeclaration parameterizedElementDeclaration, Set<Value> values) {
        Map<Integer, String> orderParts = this.orderParts(valueProviderModel, parameterizedModel.getAllParameterModels());
        HashMap<Integer, Set<Value>> valuesByPartOrder = new HashMap<Integer, Set<Value>>();
        try {
            this.filterValues(valuesByPartOrder, values, orderParts, parameterizedElementDeclaration, 1);
        }
        catch (MissingLevelException e) {
            Set level = (Set)valuesByPartOrder.get(valueProviderModel.getPartOrder());
            if (level == null) {
                throw e;
            }
            return level;
        }
        return Collections.emptySet();
    }

    private Map<Integer, String> orderParts(ValueProviderModel valueProviderModel, List<ParameterModel> parameters) {
        return parameters.stream().filter(p -> p.getValueProviderModel().map(vpm -> vpm.getProviderName().equals(valueProviderModel.getProviderName())).orElse(false)).collect(Collectors.toMap(param -> ((ValueProviderModel)param.getValueProviderModel().get()).getPartOrder(), NamedObject::getName));
    }

    private void filterValues(Map<Integer, Set<Value>> valuesByPartOrder, Set<Value> values, Map<Integer, String> orderParts, ParameterizedElementDeclaration parameterizedElementDeclaration, int level) {
        if (!values.stream().findFirst().isPresent()) {
            return;
        }
        valuesByPartOrder.put(level, values);
        String levelName = orderParts.get(level);
        Optional<String> optionalValuePartConfiguredValue = FilterUtils.getParameterConfiguredValue(parameterizedElementDeclaration, levelName).map(ParameterSimpleValueExtractor::extractSimpleValue);
        if (!optionalValuePartConfiguredValue.isPresent()) {
            throw new MissingLevelException(levelName);
        }
        String valuePartConfiguredValue = optionalValuePartConfiguredValue.get();
        Optional<Value> matchingValue = values.stream().filter(v -> v.getId().equals(valuePartConfiguredValue)).findFirst();
        if (!matchingValue.isPresent()) {
            throw new UnknownLevelValueException(levelName, valuePartConfiguredValue);
        }
        this.filterValues(valuesByPartOrder, matchingValue.get().getChilds(), orderParts, parameterizedElementDeclaration, level + 1);
    }
}

