/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.operation;

import com.hazelcast.cp.CPGroupId;
import com.hazelcast.cp.exception.CPGroupDestroyedException;
import com.hazelcast.cp.exception.NotLeaderException;
import com.hazelcast.cp.internal.RaftService;
import com.hazelcast.cp.internal.RaftSystemOperation;
import com.hazelcast.cp.internal.raft.impl.RaftNode;
import com.hazelcast.cp.internal.raft.impl.RaftNodeStatus;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.io.IOException;
import java.util.function.BiConsumer;

public abstract class RaftReplicateOp
extends Operation
implements IdentifiedDataSerializable,
RaftSystemOperation,
BiConsumer<Object, Throwable> {
    private CPGroupId groupId;

    RaftReplicateOp() {
    }

    RaftReplicateOp(CPGroupId groupId) {
        this.groupId = groupId;
    }

    @Override
    public final void run() {
        RaftService service = (RaftService)this.getService();
        RaftNode raftNode = service.getOrInitRaftNode(this.groupId);
        if (raftNode == null) {
            this.onNullRaftNode(service);
            return;
        }
        if (raftNode.getStatus() == RaftNodeStatus.STEPPED_DOWN) {
            this.sendResponse(new NotLeaderException(this.groupId, service.getLocalCPEndpoint(), null));
            this.getNodeEngine().getExecutionService().execute("hz:cpSubsystem", () -> service.stepDownRaftNode(this.groupId));
            return;
        }
        this.replicate(raftNode).whenCompleteAsync((BiConsumer)this, ConcurrencyUtil.CALLER_RUNS);
    }

    private void onNullRaftNode(RaftService service) {
        if (service.isRaftGroupDestroyed(this.groupId)) {
            this.sendResponse(new CPGroupDestroyedException(this.groupId));
        } else if (!this.groupId.equals(service.getMetadataGroupId()) && service.isDiscoveryCompleted() && service.isStartCompleted()) {
            this.sendResponseAfterMetadataCheck(service);
        } else {
            this.sendResponse(new NotLeaderException(this.groupId, service.getLocalCPEndpoint(), null));
        }
    }

    private void sendResponseAfterMetadataCheck(RaftService service) {
        this.getNodeEngine().getExecutionService().execute("hz:cpSubsystem", () -> service.getCPGroup(this.groupId).whenCompleteAsync((group, throwable) -> {
            if (group == null && throwable == null) {
                this.getLogger().info("There is no info about " + this.groupId + " in the METADATA group");
                this.sendResponse(new CPGroupDestroyedException(this.groupId));
            } else {
                this.sendResponse(new NotLeaderException(this.groupId, service.getLocalCPEndpoint(), null));
            }
        }, ConcurrencyUtil.CALLER_RUNS));
    }

    protected abstract InternalCompletableFuture replicate(RaftNode var1);

    @Override
    public void accept(Object response, Throwable throwable) {
        if (throwable == null) {
            this.sendResponse(response);
        } else {
            this.sendResponse(throwable);
        }
    }

    @Override
    public final boolean returnsResponse() {
        return false;
    }

    @Override
    public final boolean validatesTarget() {
        return false;
    }

    @Override
    public final String getServiceName() {
        return "hz:core:raft";
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.groupId);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.groupId = (CPGroupId)in.readObject();
    }

    @Override
    protected void toString(StringBuilder sb) {
        super.toString(sb);
        sb.append(", groupId=").append(this.groupId);
    }
}

