/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.license;

import de.schlichtherle.license.CipherParam;
import de.schlichtherle.license.IllegalPasswordException;
import de.schlichtherle.license.LicenseNotary;
import de.schlichtherle.license.Policy;
import de.schlichtherle.util.ObfuscatedString;
import de.schlichtherle.xml.GenericCertificate;
import de.schlichtherle.xml.PersistenceService;
import de.schlichtherle.xml.PersistenceServiceException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.util.encoders.Hex;

public class PrivacyGuard {
    private static final String PBE_WITH_MD5_AND_DES = new ObfuscatedString(new long[]{2860604316472308139L, 5030391952891038168L, -6110818099732428353L}).toString();
    private static final String AES_CBC_PKCS5Padding = new ObfuscatedString(new long[]{9134146434932393082L, 3218103396305942830L, -2754183109520092056L, -3550530648860737056L}).toString();
    private static final String AES = new ObfuscatedString(new long[]{2384870410100050833L, -8534981221243966067L}).toString();
    private static final String SALT = new ObfuscatedString(new long[]{6868215648901611394L, -4636343031852078731L, 3158976241785645161L, 3605875122779352041L, 2444988390064642384L}).toString();
    private static final String PBKDF2_WITH_HMAC_SHA256 = new ObfuscatedString(new long[]{4969671083990297104L, -302967342919482453L, 8203409604234729237L, 3990919853171785823L}).toString();
    private CipherParam param;
    private Cipher cipher;
    private SecretKey key;
    private AlgorithmParameterSpec algoParamSpec;
    private boolean fipsEnabled;

    protected PrivacyGuard() {
    }

    public PrivacyGuard(CipherParam param, boolean fipsEnabled) {
        this.fipsEnabled = fipsEnabled;
        this.setCipherParam(param);
    }

    public PrivacyGuard(CipherParam param) {
        this(param, false);
    }

    public CipherParam getCipherParam() {
        return this.param;
    }

    public void setCipherParam(CipherParam param) throws NullPointerException, IllegalPasswordException {
        if (param == null) {
            throw new NullPointerException(LicenseNotary.PARAM);
        }
        Policy.getCurrent().checkPwd(param.getKeyPwd());
        this.param = param;
        this.cipher = null;
        this.key = null;
        this.algoParamSpec = null;
    }

    public byte[] cert2key(GenericCertificate certificate) throws Exception {
        ByteArrayOutputStream keyOut = new ByteArrayOutputStream();
        GZIPOutputStream out = new GZIPOutputStream(new CipherOutputStream(keyOut, this.getCipher4Encryption()));
        try {
            PersistenceService.store((Object)certificate, (OutputStream)out);
        }
        catch (PersistenceServiceException cannotHappen) {
            throw new AssertionError((Object)cannotHappen);
        }
        return keyOut.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenericCertificate key2cert(byte[] key) throws Exception {
        GenericCertificate certificate;
        GZIPInputStream in = new GZIPInputStream(new ByteArrayInputStream(this.getCipher4Decryption().doFinal(key)));
        try {
            certificate = (GenericCertificate)PersistenceService.load((InputStream)in);
        }
        finally {
            try {
                ((InputStream)in).close();
            }
            catch (IOException iOException) {}
        }
        return certificate;
    }

    protected Cipher getCipher4Encryption() {
        Cipher cipher = this.getCipher();
        try {
            cipher.init(1, (Key)this.key, this.algoParamSpec);
        }
        catch (InvalidKeyException cannotHappen) {
            throw new AssertionError((Object)cannotHappen);
        }
        catch (InvalidAlgorithmParameterException cannotHappen) {
            throw new AssertionError((Object)cannotHappen);
        }
        return cipher;
    }

    protected Cipher getCipher4Decryption() {
        Cipher cipher = this.getCipher();
        try {
            cipher.init(2, (Key)this.key, this.algoParamSpec);
        }
        catch (InvalidKeyException cannotHappen) {
            throw new AssertionError((Object)cannotHappen);
        }
        catch (InvalidAlgorithmParameterException cannotHappen) {
            throw new AssertionError((Object)cannotHappen);
        }
        return cipher;
    }

    public static SecretKey generateSecretKey(char[] password, byte[] salt, int iterations, int keyLength) throws NoSuchAlgorithmException, InvalidKeySpecException {
        PBEKeySpec keySpec = new PBEKeySpec(password, salt, iterations, keyLength);
        SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(PBKDF2_WITH_HMAC_SHA256);
        return secretKeyFactory.generateSecret(keySpec);
    }

    protected Cipher getCipher() {
        if (this.fipsEnabled) {
            return this.getCipherForFips();
        }
        return this.getCipherForNonFips();
    }

    private Cipher getCipherForNonFips() {
        if (this.cipher != null) {
            return this.cipher;
        }
        this.algoParamSpec = new PBEParameterSpec(new byte[]{-50, -5, -34, -84, 5, 2, 25, 113}, 2005);
        try {
            PBEKeySpec keySpec = new PBEKeySpec(this.getCipherParam().getKeyPwd().toCharArray());
            SecretKeyFactory keyFac = SecretKeyFactory.getInstance(PBE_WITH_MD5_AND_DES);
            this.key = keyFac.generateSecret(keySpec);
            this.cipher = Cipher.getInstance(PBE_WITH_MD5_AND_DES);
        }
        catch (NoSuchAlgorithmException cannotHappen) {
            throw new AssertionError((Object)cannotHappen);
        }
        catch (InvalidKeySpecException cannotHappen) {
            throw new AssertionError((Object)cannotHappen);
        }
        catch (NoSuchPaddingException cannotHappen) {
            throw new AssertionError((Object)cannotHappen);
        }
        return this.cipher;
    }

    private Cipher getCipherForFips() {
        char[] password = this.getCipherParam().getKeyPwd().toCharArray();
        byte[] salt = Hex.decode((String)SALT);
        int iterations = 65536;
        int keyLength = 256;
        byte[] iv = new byte[16];
        try {
            this.key = PrivacyGuard.generateSecretKey(password, salt, iterations, keyLength);
            this.cipher = Cipher.getInstance(AES_CBC_PKCS5Padding);
            this.algoParamSpec = new IvParameterSpec(iv);
            this.key = new SecretKeySpec(this.key.getEncoded(), AES);
            return this.cipher;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

