/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.license.ftp;

import de.schlichtherle.license.IllegalPasswordException;
import de.schlichtherle.license.KeyStoreParam;
import de.schlichtherle.license.LicenseContent;
import de.schlichtherle.license.LicenseNotary;
import de.schlichtherle.license.LicenseParam;
import de.schlichtherle.license.NoLicenseInstalledException;
import de.schlichtherle.license.ftp.Resources;
import de.schlichtherle.util.ObfuscatedString;
import java.util.Calendar;
import java.util.Date;
import javax.security.auth.x500.X500Principal;

public class LicenseManager
extends de.schlichtherle.license.LicenseManager {
    private static final String FTP_KEYSTORE_PARAM = new ObfuscatedString(new long[]{6540942263743768505L, -6059958959638303164L, 6377465279464853391L}).toString();
    private static final String EQUAL_KEY_STORE_PARAMS = new ObfuscatedString(new long[]{5508595700258006979L, 4658549383733098011L, 4696761698113697678L, 7544341226212718087L, 8821059208312938461L, 302546095417378367L, 4227466611521490562L, -1772332321125311578L}).toString();
    private static final String FTP_DAYS = new ObfuscatedString(new long[]{8356037110043899424L, 4664078144517272142L}).toString();
    private LicenseNotary ftpNotary;
    private static final String CN_FTP_USER = CN + Resources.getString(new ObfuscatedString(new long[]{-6534999889298787160L, -4220048377725910008L}).toString());

    protected LicenseManager() {
    }

    public LicenseManager(de.schlichtherle.license.ftp.LicenseParam param) throws NullPointerException, IllegalPasswordException {
        this.setLicenseParam(param);
    }

    @Override
    public synchronized void setLicenseParam(LicenseParam param) throws NullPointerException, IllegalPasswordException {
        de.schlichtherle.license.ftp.LicenseParam licenseParam = (de.schlichtherle.license.ftp.LicenseParam)param;
        KeyStoreParam ftpKeyStoreParam = licenseParam.getFTPKeyStoreParam();
        if (ftpKeyStoreParam == null) {
            throw new NullPointerException(FTP_KEYSTORE_PARAM);
        }
        if (ftpKeyStoreParam.equals(licenseParam.getKeyStoreParam())) {
            throw new IllegalArgumentException(EQUAL_KEY_STORE_PARAMS);
        }
        int ftpDays = licenseParam.getFTPDays();
        if (0 >= ftpDays || ftpDays > 365) {
            throw new IllegalArgumentException(new ObfuscatedString(new long[]{-8447909007698265338L, 3963998191526449092L}).toString());
        }
        super.setLicenseParam(licenseParam);
    }

    @Override
    protected synchronized LicenseContent verify(LicenseNotary notary) throws Exception {
        try {
            return super.verify(notary);
        }
        catch (Exception exc) {
            de.schlichtherle.license.ftp.LicenseParam param = (de.schlichtherle.license.ftp.LicenseParam)this.getLicenseParam();
            LicenseNotary ftpNotary = this.getFTPLicenseNotary();
            byte[] key = this.getLicenseKey();
            if (key != null) {
                return super.verify(ftpNotary);
            }
            if (!param.isFTPEligible()) {
                throw new NoLicenseInstalledException(param.getSubject());
            }
            LicenseContent content = param.createFTPLicenseContent();
            content.setNotAfter(this.ftpNotAfter(param.getFTPDays()));
            content = this.install(this.create(content, ftpNotary), ftpNotary);
            param.removeFTPEligibility();
            param.ftpGranted(content);
            return content;
        }
    }

    @Override
    protected synchronized void initialize(LicenseContent content) {
        if (content.getHolder() == null) {
            content.setHolder(new X500Principal(CN_FTP_USER));
        }
        super.initialize(content);
    }

    protected synchronized LicenseNotary getFTPLicenseNotary() throws Exception {
        if (this.ftpNotary == null) {
            this.ftpNotary = new LicenseNotary(((de.schlichtherle.license.ftp.LicenseParam)this.getLicenseParam()).getFTPKeyStoreParam(), this.getLicenseParam().isFipsEnabled());
        }
        return this.ftpNotary;
    }

    protected Date ftpNotAfter(int ftpDays) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(LicenseManager.midnight());
        cal.add(5, ftpDays);
        return cal.getTime();
    }
}

