/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.license.wizard;

import com.nexes.wizard.WizardPanelDescriptor;
import de.schlichtherle.license.LicenseContent;
import de.schlichtherle.license.LicenseManager;
import de.schlichtherle.license.wizard.Dialogs;
import de.schlichtherle.license.wizard.LicenseInstalledEvent;
import de.schlichtherle.license.wizard.LicenseInstalledListener;
import de.schlichtherle.license.wizard.Resources;
import de.schlichtherle.swing.Defaults;
import de.schlichtherle.swing.EnhancedButton;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;

public class InstallPanel
extends JPanel {
    private final LicenseManager manager;
    private JButton fileButton;
    private final JTextField fileField = new JTextField();
    private JFileChooser filechooser;
    private EnhancedButton installButton;
    private JTextArea prompt;
    private JTextArea success;

    public InstallPanel(LicenseManager manager) {
        this.manager = manager;
        this.initComponents();
        this.fileField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                InstallPanel.this.updateFileField();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                InstallPanel.this.updateFileField();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                InstallPanel.this.updateFileField();
            }
        });
    }

    private void updateFileField() {
        String fileName = this.fileField.getText();
        this.installButton.setEnabled(fileName != null && new File(fileName).isFile());
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.updateFileField();
        }
        super.setVisible(visible);
    }

    private void initComponents() {
        this.filechooser = new JFileChooser();
        this.prompt = new JTextArea();
        this.fileButton = new JButton();
        this.installButton = new EnhancedButton();
        this.success = new JTextArea();
        this.filechooser.setFileFilter(this.manager.getFileFilter());
        this.setLayout(new GridBagLayout());
        this.prompt.setEditable(false);
        this.prompt.setFont(Defaults.labelBoldFont);
        this.prompt.setLineWrap(true);
        this.prompt.setText(Resources.getString("InstallPanel.prompt.text", new Object[]{this.manager.getLicenseParam().getSubject()}));
        this.prompt.setWrapStyleWord(true);
        this.prompt.setBorder(null);
        this.prompt.setOpaque(false);
        this.prompt.setPreferredSize(new Dimension(370, 30));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 15, 0);
        this.add((Component)this.prompt, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.add((Component)this.fileField, gridBagConstraints);
        this.fileButton.setText("...");
        this.fileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InstallPanel.this.fileButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 0);
        this.add((Component)this.fileButton, gridBagConstraints);
        this.installButton.setText(Resources.getString("InstallPanel.installButton.text"));
        this.installButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InstallPanel.this.installButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(15, 0, 0, 0);
        this.add((Component)this.installButton, gridBagConstraints);
        this.success.setEditable(false);
        this.success.setFont(Defaults.labelBoldFont);
        this.success.setBorder(null);
        this.success.setOpaque(false);
        this.success.setPreferredSize(new Dimension(350, 60));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(15, 0, 0, 0);
        this.add((Component)this.success, gridBagConstraints);
    }

    private void installButtonActionPerformed(ActionEvent evt) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            LicenseContent content = this.manager.install(new File(this.fileField.getText()));
            this.installButton.setEnabled(false);
            this.success.setText(Resources.getString("InstallPanel.success.text"));
            this.fireLicenseInstalled(content);
        }
        catch (Exception failure) {
            Dialogs.showMessageDialog(this, failure.getLocalizedMessage(), Resources.getString("InstallPanel.failure.title"), 0);
        }
        finally {
            this.setCursor(null);
        }
    }

    private void fileButtonActionPerformed(ActionEvent evt) {
        if (this.filechooser.showOpenDialog(this) != 0) {
            return;
        }
        this.fileField.setText(this.filechooser.getSelectedFile().getPath());
    }

    public synchronized void addLicenseInstalledListener(LicenseInstalledListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(LicenseInstalledListener.class, listener);
    }

    public synchronized void removeLicenseInstalledListener(LicenseInstalledListener listener) {
        this.listenerList.remove(LicenseInstalledListener.class, listener);
    }

    protected void fireLicenseInstalled(LicenseContent content) {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        LicenseInstalledEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != LicenseInstalledListener.class) continue;
            if (e == null) {
                e = new LicenseInstalledEvent(this, content);
            }
            ((LicenseInstalledListener)listeners[i + 1]).licenseInstalled(e);
        }
    }

    public static class Descriptor
    extends WizardPanelDescriptor {
        public static final String IDENTIFIER = "INSTALL_PANEL";

        public Descriptor(LicenseManager manager) {
            this.setPanelDescriptorIdentifier(IDENTIFIER);
            InstallPanel panel = new InstallPanel(manager);
            this.setPanelComponent(panel);
            panel.addLicenseInstalledListener(new LicenseInstalledListener(){

                @Override
                public void licenseInstalled(LicenseInstalledEvent evt) {
                    this.getWizardModel().setNextButtonEnabled(Boolean.TRUE);
                }
            });
        }

        public Object getNextPanelDescriptor() {
            return "LICENSE_PANEL";
        }

        public Object getBackPanelDescriptor() {
            return "WELCOME_PANEL";
        }

        public void aboutToDisplayPanel() {
            InstallPanel panel = (InstallPanel)this.getPanelComponent();
            panel.success.setText(null);
            this.getWizardModel().setNextButtonEnabled(Boolean.FALSE);
        }
    }
}

