/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.license.wizard;

import com.nexes.wizard.WizardPanelDescriptor;
import de.schlichtherle.license.LicenseManager;
import de.schlichtherle.license.wizard.Dialogs;
import de.schlichtherle.license.wizard.LicenseUninstalledEvent;
import de.schlichtherle.license.wizard.LicenseUninstalledListener;
import de.schlichtherle.license.wizard.Resources;
import de.schlichtherle.swing.Defaults;
import de.schlichtherle.swing.EnhancedButton;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.event.EventListenerList;

public class UninstallPanel
extends JPanel {
    private final LicenseManager manager;
    private JTextArea prompt;
    private EnhancedButton uninstallButton;

    public UninstallPanel(LicenseManager manager) {
        this.manager = manager;
        this.initComponents();
    }

    private void initComponents() {
        this.prompt = new JTextArea();
        this.uninstallButton = new EnhancedButton();
        this.setLayout(new GridBagLayout());
        this.prompt.setEditable(false);
        this.prompt.setFont(Defaults.labelBoldFont);
        this.prompt.setLineWrap(true);
        this.prompt.setText(Resources.getString("UninstallPanel.prompt.text", new Object[]{this.manager.getLicenseParam().getSubject()}));
        this.prompt.setWrapStyleWord(true);
        this.prompt.setBorder(null);
        this.prompt.setOpaque(false);
        this.prompt.setPreferredSize(new Dimension(370, 30));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 15, 0);
        this.add((Component)this.prompt, gridBagConstraints);
        this.uninstallButton.setText(Resources.getString("UninstallPanel.uninstallButton.text"));
        this.uninstallButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UninstallPanel.this.uninstallButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.uninstallButton, gridBagConstraints);
    }

    private void uninstallButtonActionPerformed(ActionEvent evt) {
        try {
            this.manager.uninstall();
            this.uninstallButton.setEnabled(false);
            this.fireLicenseUninstalled();
        }
        catch (Exception failure) {
            Dialogs.showMessageDialog(this, failure.getLocalizedMessage(), Resources.getString("UnInstallPanel.failure.title"), 0);
        }
    }

    public synchronized void addLicenseUninstalledListener(LicenseUninstalledListener listener) {
        if (this.listenerList == null) {
            this.listenerList = new EventListenerList();
        }
        this.listenerList.add(LicenseUninstalledListener.class, listener);
    }

    public synchronized void removeLicenseUninstalledListener(LicenseUninstalledListener listener) {
        this.listenerList.remove(LicenseUninstalledListener.class, listener);
    }

    protected void fireLicenseUninstalled() {
        if (this.listenerList == null) {
            return;
        }
        Object[] listeners = this.listenerList.getListenerList();
        LicenseUninstalledEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != LicenseUninstalledListener.class) continue;
            if (e == null) {
                e = new LicenseUninstalledEvent(this);
            }
            ((LicenseUninstalledListener)listeners[i + 1]).licenseUninstalled(e);
        }
    }

    public static class Descriptor
    extends WizardPanelDescriptor {
        public static final String IDENTIFIER = "UNINSTALL_PANEL";

        public Descriptor(LicenseManager manager) {
            this.setPanelDescriptorIdentifier(IDENTIFIER);
            UninstallPanel panel = new UninstallPanel(manager);
            this.setPanelComponent(panel);
            panel.addLicenseUninstalledListener(new LicenseUninstalledListener(){

                @Override
                public void licenseUninstalled(LicenseUninstalledEvent evt) {
                    this.getWizardModel().setNextButtonEnabled(Boolean.TRUE);
                }
            });
        }

        public Object getNextPanelDescriptor() {
            return FINISH;
        }

        public Object getBackPanelDescriptor() {
            return "WELCOME_PANEL";
        }

        public void aboutToDisplayPanel() {
            ((UninstallPanel)this.getPanelComponent()).uninstallButton.setEnabled(true);
            this.getWizardModel().setNextButtonEnabled(Boolean.FALSE);
        }
    }
}

