/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.application;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.mule.maven.pom.parser.api.BundleDescriptorCreationException;
import org.mule.maven.pom.parser.api.MavenPomParserProvider;
import org.mule.maven.pom.parser.api.model.MavenPomModel;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.tooling.client.api.Disposable;
import org.mule.tooling.client.api.exception.ToolingException;
import org.mule.tooling.client.internal.application.DefaultApplication;
import org.mule.tooling.client.internal.utils.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArtifactResources
implements Disposable {
    private static final int CONNECT_TIMEOUT = 5000;
    private static final int READ_TIMEOUT = 5000;
    private static final String FILE_PROTOCOL = "file";
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultApplication.class);
    private final String artifactId;
    private final URL artifactUrlContent;
    private File rootArtifactFile;
    private File workingDirectory;
    private final ArtifactType artifactType;

    public ArtifactResources(String artifactId, URL artifactUrlContent) {
        Objects.requireNonNull(artifactUrlContent, "artifactUrlContent cannot be null");
        this.artifactUrlContent = artifactUrlContent;
        this.artifactId = artifactId;
        this.explode(artifactUrlContent);
        this.artifactType = ArtifactResources.discoverArtifactType(this.rootArtifactFile);
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public URL getArtifactUrlContent() {
        return this.artifactUrlContent;
    }

    public File getRootArtifactFile() {
        return this.rootArtifactFile;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public ArtifactType getArtifactType() {
        return this.artifactType;
    }

    public boolean isRemote() {
        return !ArtifactResources.isFileProtocol(this.artifactUrlContent) && !ArtifactResources.isArtifactExploded(this.artifactUrlContent);
    }

    public void dispose() {
        boolean fileDeleted;
        if (!ArtifactResources.isArtifactExploded(this.artifactUrlContent)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Deleting temporary file used for artifact");
            }
            if (!(fileDeleted = FileUtils.deleteQuietly((File)this.rootArtifactFile)) && LOGGER.isWarnEnabled()) {
                LOGGER.warn("Couldn't delete temporary artifact file: {}", (Object)this.rootArtifactFile.getAbsoluteFile());
            }
        }
        if (this.workingDirectory != null && this.workingDirectory.exists() && !(fileDeleted = FileUtils.deleteQuietly((File)this.workingDirectory)) && LOGGER.isWarnEnabled()) {
            LOGGER.warn("Couldn't delete temporary working artifact file: {}", (Object)this.workingDirectory.getAbsoluteFile());
        }
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    private void explode(URL artifactUrlContent) {
        block12: {
            this.workingDirectory = com.google.common.io.Files.createTempDir();
            try {
                if (ArtifactResources.isArtifactExploded(artifactUrlContent)) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Artifact URL already references to a file location with the content exploded");
                    }
                    this.rootArtifactFile = FileUtils.toFile((URL)artifactUrlContent);
                    break block12;
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Artifact URL either references to a remote location or a file location with packaged jar, copying to a temporary folder");
                }
                this.rootArtifactFile = Files.createTempDirectory("artifact", new FileAttribute[0]).toFile();
                this.rootArtifactFile.deleteOnExit();
                if (!ArtifactResources.isFileProtocol(artifactUrlContent)) {
                    try (InputStream fileContent = IOUtils.readContentFromUrl(artifactUrlContent, 5000, 5000);){
                        org.mule.runtime.core.api.util.FileUtils.unzip((InputStream)fileContent, (File)this.rootArtifactFile);
                        break block12;
                    }
                }
                org.mule.runtime.core.api.util.FileUtils.unzip((File)FileUtils.toFile((URL)artifactUrlContent), (File)this.rootArtifactFile);
            }
            catch (IOException e) {
                throw new ToolingException(String.format("Couldn't expand the artifact or content to a temporary folder from URL: %s", artifactUrlContent), (Throwable)e);
            }
        }
    }

    private static ArtifactType discoverArtifactType(File rootArtifactFile) {
        MavenPomModel pomModel;
        try {
            pomModel = MavenPomParserProvider.discoverProvider().createMavenPomParserClient(rootArtifactFile.toPath()).getModel();
        }
        catch (BundleDescriptorCreationException e) {
            throw new ToolingException(String.format("Couldn't load pom model from artifact %s", rootArtifactFile.getAbsolutePath()), (Throwable)e);
        }
        String packaging = pomModel.getPackaging();
        if (packaging.equals("mule-domain")) {
            return ArtifactType.DOMAIN;
        }
        if (packaging.equals("mule-application")) {
            return ArtifactType.APP;
        }
        throw new IllegalArgumentException(String.format("Couldn't identify type of artifact, pom packaging '%s' is not supported, it should be one of '%s' or '%s'", packaging, "mule-domain", "mule-application"));
    }

    private static boolean isFileProtocol(URL artifactUrlContent) {
        return artifactUrlContent.getProtocol().equals(FILE_PROTOCOL);
    }

    private static boolean isArtifactExploded(URL artifactUrlContent) {
        return ArtifactResources.isFileProtocol(artifactUrlContent) && FileUtils.toFile((URL)artifactUrlContent).isDirectory();
    }
}

