/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.application;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.mule.runtime.core.api.config.bootstrap.ArtifactType;
import org.mule.tooling.agent.RuntimeToolingService;
import org.mule.tooling.client.api.exception.ToolingException;
import org.mule.tooling.client.internal.application.AbstractArtifactDeployer;
import org.mule.tooling.client.internal.application.ArtifactResources;
import org.mule.tooling.client.internal.utils.IOUtils;

public class InputStreamArtifactDeployer
extends AbstractArtifactDeployer {
    private static final int CONNECT_TIMEOUT = 5000;
    private static final int READ_TIMEOUT = 5000;
    private Function<AbstractArtifactDeployer.DeploymentContext, String> deployFunction;
    private Consumer<AbstractArtifactDeployer.DeploymentContext> disposeFunction;

    public InputStreamArtifactDeployer(ArtifactResources artifactResources, Supplier<RuntimeToolingService> runtimeToolingService, Map<String, String> deploymentProperties) {
        super(artifactResources, runtimeToolingService, deploymentProperties);
        if (artifactResources.getArtifactType().equals((Object)ArtifactType.DOMAIN)) {
            this.deployFunction = deploymentContext -> deploymentContext.getRuntimeToolingService().deployDomain(deploymentContext.getArtifactId(), deploymentContext.getContent(), deploymentContext.getDeploymentProperties());
            this.disposeFunction = deploymentContext -> deploymentContext.getRuntimeToolingService().disposeDomain(deploymentContext.getArtifactId());
        } else {
            this.deployFunction = deploymentContext -> {
                if (deploymentContext.getDomainId() != null) {
                    return deploymentContext.getRuntimeToolingService().deployApplication(deploymentContext.getArtifactId(), deploymentContext.getContent(), deploymentContext.getDomainId(), deploymentContext.getDeploymentProperties());
                }
                return deploymentContext.getRuntimeToolingService().deployApplication(deploymentContext.getArtifactId(), deploymentContext.getContent(), deploymentContext.getDeploymentProperties());
            };
            this.disposeFunction = deploymentContext -> deploymentContext.getRuntimeToolingService().disposeApplication(deploymentContext.getArtifactId());
        }
    }

    @Override
    protected String doInternalDeploy(ArtifactResources artifactResources, RuntimeToolingService runtimeToolingService, String domainId, Map<String, String> deploymentProperties) {
        String string;
        block9: {
            if (this.LOGGER.isDebugEnabled()) {
                this.LOGGER.debug("Deploying artifact from URL: {}", (Object)artifactResources);
            }
            InputStream content = IOUtils.readContentFromUrl(artifactResources.getArtifactUrlContent(), 5000, 5000);
            try {
                string = this.deployFunction.apply(new AbstractArtifactDeployer.DeploymentContext((AbstractArtifactDeployer)this, artifactResources.getArtifactId(), content, domainId, deploymentProperties, runtimeToolingService));
                if (content == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (content != null) {
                        try {
                            content.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ToolingException(String.format("Couldn't deploy an artifact from URL: %s", artifactResources.getArtifactUrlContent()), (Throwable)e);
                }
            }
            content.close();
        }
        return string;
    }

    @Override
    protected void doInternalDispose(String id, RuntimeToolingService runtimeToolingService) {
        this.disposeFunction.accept(new AbstractArtifactDeployer.DeploymentContext(this, id, runtimeToolingService));
    }
}

