/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.session.mediator.resolver;

import java.util.Collections;
import java.util.Set;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.parameter.ValueProviderModel;
import org.mule.runtime.api.value.Value;
import org.mule.runtime.api.value.ValueResult;
import org.mule.runtime.app.declaration.api.ElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterizedElementDeclaration;
import org.mule.tooling.client.api.value.resolver.ValueResolverResult;
import org.mule.tooling.client.internal.session.cache.DeclarationValueProviderCache;
import org.mule.tooling.client.internal.session.filter.ValueFilter;
import org.mule.tooling.client.internal.session.filter.exception.InvalidLevelValueException;
import org.mule.tooling.client.internal.session.filter.exception.MissingLevelException;
import org.mule.tooling.client.internal.session.filter.exception.UnknownLevelValueException;
import org.mule.tooling.client.internal.session.mediator.resolver.SessionFunction;
import org.mule.tooling.client.internal.session.mediator.resolver.SkeletalValueResolver;
import org.mule.tooling.client.internal.session.mediator.resolver.ValuesResolver;
import org.mule.tooling.client.internal.utils.ValueResolverUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValueProviderResolver
extends SkeletalValueResolver<ValueResult>
implements ValuesResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(ValueProviderResolver.class);
    private final ParameterizedElementDeclaration elementDeclaration;
    private final ValueProviderModel valueProviderModel;
    private final DeclarationValueProviderCache valueProviderCache;
    private final ValueFilter valueFilter;

    public ValueProviderResolver(SessionFunction<ValueResult> sessionExecutorConsumer, boolean ignoreCache, ParameterizedElementDeclaration elementDeclaration, ValueProviderModel valueProviderModel, DeclarationValueProviderCache valueProviderCache, ValueFilter valueFilter) {
        super(sessionExecutorConsumer, ignoreCache);
        this.elementDeclaration = elementDeclaration;
        this.valueProviderModel = valueProviderModel;
        this.valueProviderCache = valueProviderCache;
        this.valueFilter = valueFilter;
    }

    @Override
    public ValueResolverResult resolve(ParameterizedModel parameterizedModel, ParameterModel parameterModel, String parameterName) {
        Set<Value> requestedLevelValues;
        block6: {
            ValueResult values;
            String providerName = this.valueProviderModel.getProviderName();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Resolving values using ValueProvider mechanism for parameter: '{}' using providerName: '{}' on element: '{}' for declared for extension: '{}'", new Object[]{parameterName, providerName, this.elementDeclaration.getName(), this.elementDeclaration.getDeclaringExtension()});
            }
            if (!(values = this.valueProviderCache.getValues((ElementDeclaration)this.elementDeclaration, parameterName, () -> (ValueResult)this.sessionFunction.apply((runtimeToolingService, id) -> runtimeToolingService.getValues(id, this.elementDeclaration, providerName)), this.ignoreCache)).isSuccess()) {
                return ValueResolverUtils.toValueResolverResult(values);
            }
            requestedLevelValues = Collections.emptySet();
            try {
                requestedLevelValues = this.valueFilter.filter(this.valueProviderModel, parameterizedModel, this.elementDeclaration, values.getValues());
            }
            catch (MissingLevelException e) {
                return this.missingActingParametersFailure(e.getMissingParameterName());
            }
            catch (InvalidLevelValueException e) {
                return this.invalidActingParameterFailure(e.getTargetSelector(), e.getMessage());
            }
            catch (UnknownLevelValueException e) {
                if (this.valueProviderModel.isOpen() || this.valueProviderModel.getPartOrder() <= 1) break block6;
                return this.unknownActingParametersFailure(e.getParameterName(), e.getParameterValue());
            }
        }
        return ValueResolverResult.success(ValueResolverUtils.toResolvedValues(requestedLevelValues));
    }
}

