/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.serialization.kryo.internal;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.FieldSerializer;
import com.mulesoft.mule.runtime.module.serialization.kryo.internal.MuleKryoSerializerSupport;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.activation.DataHandler;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.serialization.SerializationException;
import org.mule.runtime.core.internal.message.DefaultMessageBuilder;
import org.mule.runtime.core.internal.message.InternalMessage;

final class MuleMessageKryoSerializer
extends MuleKryoSerializerSupport<InternalMessage> {
    private final FieldSerializer<DefaultMessageBuilder> serializer;

    public MuleMessageKryoSerializer(Kryo kryo) {
        this.serializer = new FieldSerializer(kryo, DefaultMessageBuilder.class);
    }

    public void write(Kryo kryo, Output output, final InternalMessage message) {
        this.serializer.write(kryo, output, (Object)((DefaultMessageBuilder)new DefaultMessageBuilder((Message)message).nullValue()));
        kryo.writeClassAndObject(output, message.getPayload().getValue());
        new AttachmentSerializer(){

            @Override
            protected Object getAttachment(String name) {
                return message.getInboundAttachment(name);
            }

            @Override
            protected Collection<String> getAttachmentNames() {
                return message.getInboundAttachmentNames();
            }
        }.serializeAttachments(kryo, output);
        new AttachmentSerializer(){

            @Override
            protected Object getAttachment(String name) {
                return message.getOutboundAttachment(name);
            }

            @Override
            protected Collection<String> getAttachmentNames() {
                return message.getOutboundAttachmentNames();
            }
        }.serializeAttachments(kryo, output);
    }

    public InternalMessage read(Kryo kryo, Input input, Class<InternalMessage> type) {
        final DefaultMessageBuilder messageBuilder = (DefaultMessageBuilder)this.serializer.read(kryo, input, DefaultMessageBuilder.class);
        messageBuilder.value(kryo.readClassAndObject(input));
        new AttachmentDeserealizer(){

            @Override
            protected void acceptAttachment(String key, DataHandler data) throws Exception {
                messageBuilder.addInboundAttachment(key, data);
            }
        }.deserealizeAttachments(kryo, input);
        new AttachmentDeserealizer(){

            @Override
            protected void acceptAttachment(String key, DataHandler data) throws Exception {
                messageBuilder.addOutboundAttachment(key, data);
            }
        }.deserealizeAttachments(kryo, input);
        return messageBuilder.build();
    }

    private abstract class AttachmentDeserealizer {
        private AttachmentDeserealizer() {
        }

        protected void deserealizeAttachments(Kryo kryo, Input input) {
            Map attachments = (Map)kryo.readObject(input, HashMap.class);
            try {
                for (Map.Entry entry : attachments.entrySet()) {
                    this.acceptAttachment((String)entry.getKey(), (DataHandler)entry.getValue());
                }
            }
            catch (Exception e) {
                throw new SerializationException("Exception was found adding attachment to a Message", (Throwable)e);
            }
        }

        protected abstract void acceptAttachment(String var1, DataHandler var2) throws Exception;
    }

    private abstract class AttachmentSerializer {
        private AttachmentSerializer() {
        }

        protected void serializeAttachments(Kryo kryo, Output output) {
            HashMap<String, DataHandler> attachments = new HashMap<String, DataHandler>();
            for (String name : this.getAttachmentNames()) {
                attachments.put(name, (DataHandler)this.getAttachment(name));
            }
            kryo.writeObject(output, attachments);
        }

        protected abstract Collection<String> getAttachmentNames();

        protected abstract Object getAttachment(String var1);
    }
}

