/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.internal.dsl;

import com.mulesoft.mule.runtime.core.internal.config.scheduler.SchedulerPoolsArtifactConfigFactory;
import javax.inject.Inject;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.scheduler.SchedulerPoolStrategy;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.dsl.api.component.AbstractComponentFactory;

public class SchedulerPoolsArtifactConfigObjectFactory
extends AbstractComponentFactory<SchedulerPoolsArtifactConfigFactory> {
    @Inject
    private MuleConfiguration muleConfiguration;
    private long gracefulShutdownTimeout;
    private SchedulerPoolStrategy poolStrategy;
    private SchedulerPoolsArtifactConfigFactory.IoPoolConfig uberPoolConfig;
    private SchedulerPoolsArtifactConfigFactory.CpuLightPoolConfig cpuLightPoolConfig;
    private SchedulerPoolsArtifactConfigFactory.IoPoolConfig ioPoolConfig;
    private SchedulerPoolsArtifactConfigFactory.CpuIntensivePoolConfig cpuIntensivePoolConfig;

    public SchedulerPoolsArtifactConfigFactory doGetObject() throws Exception {
        if (this.poolStrategy == SchedulerPoolStrategy.UBER) {
            if (this.cpuLightPoolConfig != null || this.ioPoolConfig != null || this.cpuIntensivePoolConfig != null) {
                throw new ConfigurationException(I18nMessageFactory.createStaticMessage((String)String.format("cpuLight, cpuIntensive and io thread pools cannot be configured When the '%s' poolStrategy is selected", SchedulerPoolStrategy.UBER)));
            }
        } else {
            if (this.uberPoolConfig != null) {
                throw new ConfigurationException(I18nMessageFactory.createStaticMessage((String)String.format("'%s' pool cannot be configured When the '%s' poolStrategy is selected", SchedulerPoolStrategy.UBER.name().toLowerCase(), SchedulerPoolStrategy.DEDICATED)));
            }
            if (this.cpuLightPoolConfig == null || this.ioPoolConfig == null || this.cpuIntensivePoolConfig == null) {
                throw new ConfigurationException(I18nMessageFactory.createStaticMessage((String)String.format("All three (cpuLight, cpuIntensive and io thread pools) must be configured When the '%s' poolStrategy is selected", SchedulerPoolStrategy.DEDICATED)));
            }
        }
        return new SchedulerPoolsArtifactConfigFactory(this.muleConfiguration.getId(), this.gracefulShutdownTimeout, this.poolStrategy, this.uberPoolConfig, this.cpuLightPoolConfig, this.ioPoolConfig, this.cpuIntensivePoolConfig);
    }

    public long getGracefulShutdownTimeout() {
        return this.gracefulShutdownTimeout;
    }

    public void setGracefulShutdownTimeout(long gracefulShutdownTimeout) {
        this.gracefulShutdownTimeout = gracefulShutdownTimeout;
    }

    public SchedulerPoolStrategy getPoolStrategy() {
        return this.poolStrategy;
    }

    public void setPoolStrategy(SchedulerPoolStrategy poolStrategy) {
        this.poolStrategy = poolStrategy;
    }

    public SchedulerPoolsArtifactConfigFactory.IoPoolConfig getUberPoolConfig() {
        return this.uberPoolConfig;
    }

    public void setUberPoolConfig(SchedulerPoolsArtifactConfigFactory.IoPoolConfig uberPoolConfig) {
        this.uberPoolConfig = uberPoolConfig;
    }

    public SchedulerPoolsArtifactConfigFactory.CpuLightPoolConfig getCpuLightPoolConfig() {
        return this.cpuLightPoolConfig;
    }

    public void setCpuLightPoolConfig(SchedulerPoolsArtifactConfigFactory.CpuLightPoolConfig cpuLightPoolConfig) {
        this.cpuLightPoolConfig = cpuLightPoolConfig;
    }

    public SchedulerPoolsArtifactConfigFactory.IoPoolConfig getIoPoolConfig() {
        return this.ioPoolConfig;
    }

    public void setIoPoolConfig(SchedulerPoolsArtifactConfigFactory.IoPoolConfig ioPoolConfig) {
        this.ioPoolConfig = ioPoolConfig;
    }

    public SchedulerPoolsArtifactConfigFactory.CpuIntensivePoolConfig getCpuIntensivePoolConfig() {
        return this.cpuIntensivePoolConfig;
    }

    public void setCpuIntensivePoolConfig(SchedulerPoolsArtifactConfigFactory.CpuIntensivePoolConfig cpuIntensivePoolConfig) {
        this.cpuIntensivePoolConfig = cpuIntensivePoolConfig;
    }
}

