/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.apikit.metadata.internal.amf;

import amf.apicontract.client.platform.APIConfiguration;
import amf.core.client.platform.model.domain.Shape;
import amf.shapes.client.platform.model.domain.AnyShape;
import amf.shapes.client.platform.model.domain.ArrayShape;
import amf.shapes.client.platform.model.domain.FileShape;
import java.util.Optional;
import java.util.Set;
import org.json.JSONObject;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.AnyType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.json.api.JsonExampleTypeLoader;
import org.mule.metadata.json.api.JsonTypeLoader;
import org.mule.module.apikit.metadata.internal.utils.CommonMetadataFactory;

class MetadataFactory {
    private static final MetadataType STRING_METADATA = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).stringType().build();
    private static final MetadataType ARRAY_STRING_METADATA = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).arrayType().of(STRING_METADATA).build();
    private static final MetadataType DATE_TIME_METADATA = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).dateTimeType().build();
    private static final MetadataType BOOLEAN_METADATA = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).booleanType().build();
    private static final MetadataType INTEGER_METADATA = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).numberType().integer().build();
    private static final MetadataType NUMBER_METADATA = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).numberType().build();
    private static final String AMF_XSD_SCHEMA_KEY = "x-amf-schema";

    private MetadataFactory() {
    }

    public static MetadataType fromJSONSchema(Shape shape, String example) {
        Optional metadataType = Optional.empty();
        if (shape instanceof AnyShape) {
            AnyShape anyShape = (AnyShape)shape;
            JsonTypeLoader typeLoader = new JsonTypeLoader(APIConfiguration.API().elementClient().buildJsonSchema(anyShape));
            metadataType = typeLoader.load(null);
            if (!(metadataType.isPresent() && !(metadataType.get() instanceof AnyType) || example.isEmpty())) {
                metadataType = MetadataFactory.createJsonExampleTypeLoader(example).load(null);
            }
        }
        return metadataType.orElse(CommonMetadataFactory.defaultMetadata());
    }

    public static MetadataType fromXSDSchema(Shape shape, String example) {
        MetadataType fromExample;
        AnyShape anyShape;
        Optional<String> xsdSchema;
        if (shape instanceof AnyShape && (xsdSchema = MetadataFactory.getXSDSchemaFromShape(anyShape = (AnyShape)shape)).isPresent()) {
            return CommonMetadataFactory.fromXSDSchema(xsdSchema.get());
        }
        if (example != null && !example.isEmpty() && (fromExample = CommonMetadataFactory.fromXMLExample(example)) != null) {
            return fromExample;
        }
        return MetadataFactory.fromJSONSchema(shape, example);
    }

    private static Optional<String> getXSDSchemaFromShape(AnyShape anyShape) {
        JSONObject jsonSchema = new JSONObject(APIConfiguration.API().elementClient().buildJsonSchema(anyShape));
        String[] reference = jsonSchema.get("$ref").toString().split("/");
        JSONObject jsonSchemaDefinition = jsonSchema.getJSONObject("definitions").getJSONObject(reference[reference.length - 1]);
        Set keys = jsonSchemaDefinition.keySet();
        if (keys.contains(AMF_XSD_SCHEMA_KEY)) {
            return Optional.of(jsonSchemaDefinition.getString(AMF_XSD_SCHEMA_KEY));
        }
        return Optional.empty();
    }

    static MetadataType defaultMetadata(Shape shape) {
        if (shape instanceof FileShape) {
            return MetadataFactory.stringMetadata();
        }
        if (shape instanceof ArrayShape) {
            return MetadataFactory.arrayStringMetadata();
        }
        return CommonMetadataFactory.defaultMetadata();
    }

    private static JsonExampleTypeLoader createJsonExampleTypeLoader(String example) {
        JsonExampleTypeLoader typeLoader = new JsonExampleTypeLoader(example);
        typeLoader.setFieldRequirementDefault(false);
        return typeLoader;
    }

    static MetadataType stringMetadata() {
        return STRING_METADATA;
    }

    static MetadataType arrayStringMetadata() {
        return ARRAY_STRING_METADATA;
    }

    static MetadataType booleanMetadada() {
        return BOOLEAN_METADATA;
    }

    static MetadataType numberMetadata() {
        return NUMBER_METADATA;
    }

    static MetadataType integerMetadata() {
        return INTEGER_METADATA;
    }

    static MetadataType dateTimeMetadata() {
        return DATE_TIME_METADATA;
    }

    static MetadataType objectMetadata() {
        return BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).objectType().build();
    }

    static MetadataType binaryMetadata() {
        return BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).binaryType().build();
    }
}

