/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.runtime.module.serialization.kryo.internal.serializers;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class MuleSynchronizedCollectionsSerializer
extends Serializer<Object> {
    public Object read(Kryo kryo, Input input, Class<Object> clazz) {
        int ordinal = input.readInt(true);
        SynchronizedCollection collection = SynchronizedCollection.values()[ordinal];
        Object sourceCollection = kryo.readClassAndObject(input);
        return collection.create(sourceCollection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Kryo kryo, Output output, Object object) {
        try {
            Object internal;
            SynchronizedCollection collection = SynchronizedCollection.valueOfType(object.getClass());
            output.writeInt(collection.ordinal(), true);
            Object object2 = object;
            synchronized (object2) {
                internal = collection.getCollection(object);
            }
            kryo.writeClassAndObject(output, internal);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Object copy(Kryo kryo, Object original) {
        try {
            SynchronizedCollection collection = SynchronizedCollection.valueOfType(original.getClass());
            Object sourceCollectionCopy = kryo.copy(collection.getCollection(original));
            return collection.create(sourceCollectionCopy);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void registerSerializers(Kryo kryo) {
        MuleSynchronizedCollectionsSerializer serializer = new MuleSynchronizedCollectionsSerializer();
        for (SynchronizedCollection item : SynchronizedCollection.values()) {
            kryo.register(item.type, (Serializer)serializer);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum SynchronizedCollection {
        COLLECTION((Class)Collections.synchronizedCollection(Arrays.asList("")).getClass()){

            @Override
            public Object getCollection(Object toSerialize) {
                Collection collection = (Collection)toSerialize;
                return Arrays.asList(collection.toArray());
            }

            @Override
            public Object create(Object sourceCollection) {
                return Collections.synchronizedCollection((Collection)sourceCollection);
            }
        }
        ,
        RANDOM_ACCESS_LIST((Class)Collections.synchronizedList(new ArrayList<E>()).getClass()){

            @Override
            public Object getCollection(Object toSerialize) {
                List list = (List)toSerialize;
                return new ArrayList(list);
            }

            @Override
            public Object create(Object sourceCollection) {
                return Collections.synchronizedList((List)sourceCollection);
            }
        }
        ,
        LIST((Class)Collections.synchronizedList(new LinkedList<E>()).getClass()){

            @Override
            public Object getCollection(Object toSerialize) {
                List list = (List)toSerialize;
                return new LinkedList(list);
            }

            @Override
            public Object create(Object sourceCollection) {
                return Collections.synchronizedList((List)sourceCollection);
            }
        }
        ,
        SET((Class)Collections.synchronizedSet(new HashSet<E>()).getClass()){

            @Override
            public Object getCollection(Object toSerialize) {
                Set set = (Set)toSerialize;
                return new HashSet(set);
            }

            @Override
            public Object create(Object sourceCollection) {
                return Collections.synchronizedSet((Set)sourceCollection);
            }
        }
        ,
        SORTED_SET((Class)Collections.synchronizedSortedSet(new TreeSet<E>()).getClass()){

            @Override
            public Object getCollection(Object toSerialize) {
                SortedSet sortedSet = (SortedSet)toSerialize;
                return new TreeSet(sortedSet);
            }

            @Override
            public Object create(Object sourceCollection) {
                return Collections.synchronizedSortedSet((SortedSet)sourceCollection);
            }
        }
        ,
        MAP((Class)Collections.synchronizedMap(new HashMap<K, V>()).getClass()){

            @Override
            public Object getCollection(Object toSerialize) {
                Map map = (Map)toSerialize;
                return new HashMap(map);
            }

            @Override
            public Object create(Object sourceCollection) {
                return Collections.synchronizedMap((Map)sourceCollection);
            }
        }
        ,
        SORTED_MAP((Class)Collections.synchronizedSortedMap(new TreeMap<K, V>()).getClass()){

            @Override
            public Object getCollection(Object toSerialize) {
                SortedMap sortedMap = (SortedMap)toSerialize;
                return new TreeMap(sortedMap);
            }

            @Override
            public Object create(Object sourceCollection) {
                return Collections.synchronizedSortedMap((SortedMap)sourceCollection);
            }
        };

        private final Class<?> type;

        private SynchronizedCollection(Class<?> type) {
            this.type = type;
        }

        public abstract Object create(Object var1);

        public abstract Object getCollection(Object var1);

        static SynchronizedCollection valueOfType(Class<?> type) {
            for (SynchronizedCollection item : SynchronizedCollection.values()) {
                if (!item.type.equals(type)) continue;
                return item;
            }
            throw new IllegalArgumentException("The type " + String.valueOf(type) + " is not supported.");
        }
    }
}

