/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.external.handlers.deployment;

import com.google.inject.Inject;
import com.mulesoft.agent.domain.deployment.Domain;
import com.mulesoft.agent.exception.AgentEnableOperationException;
import com.mulesoft.agent.exception.ConcurrentDeploymentException;
import com.mulesoft.agent.external.handlers.ConfigurableExternalHandler;
import com.mulesoft.agent.external.handlers.deployment.DeploymentRequest;
import com.mulesoft.agent.services.DomainService;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.NoSuchElementException;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.io.IOUtils;

@Named(value="domains.request.handler")
@Path(value="domains")
@Singleton
public class DomainsRequestHandler
extends ConfigurableExternalHandler {
    @Inject
    protected DomainService domainService;

    public void enable(boolean state) throws AgentEnableOperationException {
        this.enabledSwitch.switchTo(state);
    }

    public boolean isEnabled() {
        return this.enabledSwitch.isEnabled();
    }

    @GET
    @Produces(value={"application/json"})
    public Response listDomains() {
        if (this.isEnabled()) {
            List domains = this.domainService.listDomains();
            if (domains == null || domains.isEmpty()) {
                return Response.noContent().build();
            }
            return Response.ok((Object)domains).build();
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)("{\"errorType\":\"" + IllegalAccessException.class + "\", \"errorMessage\":\"Message handler is disabled\" }")).build();
    }

    @GET
    @Path(value="{domain}")
    @Produces(value={"application/json"})
    public Response getDomain(@PathParam(value="domain") String domainName) {
        if (this.isEnabled()) {
            Domain domain = this.domainService.getDomain(domainName);
            if (domain == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("{\"errorType\":\"" + NoSuchElementException.class + "\", \"errorMessage\":\"No such domain\" }")).build();
            }
            return Response.ok((Object)domain).build();
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)("{\"errorType\":\"" + IllegalAccessException.class + "\", \"errorMessage\":\"Message handler is disabled\" }")).build();
    }

    @PUT
    @Path(value="{domain}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response deploy(@PathParam(value="domain") String domainName, DeploymentRequest deploymentRequest) {
        if (this.isEnabled()) {
            try {
                Domain domain = this.domainService.getDomain(domainName);
                if (domain == null) {
                    this.domainService.deploy(domainName, deploymentRequest.getUrl());
                    return Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)("{ \"application\":{\"name\":\"" + domainName + "\"}, \"status\":\"Deployment attempt started\" }")).build();
                }
                this.domainService.redeploy(domainName, deploymentRequest.getUrl());
                return Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)("{ \"application\":{\"name\":\"" + domainName + "\"}, \"status\":\"Deployment attempt started\" }")).build();
            }
            catch (ConcurrentDeploymentException e) {
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("{\"errorType\":\"" + ((Object)((Object)e)).getClass() + "\", \"errorMessage\":\"" + e.getMessage() + "\" }")).build();
            }
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)("{\"errorType\":\"" + IllegalAccessException.class + "\", \"errorMessage\":\"Message handler is disabled\" }")).build();
    }

    @PUT
    @Path(value="{domain}")
    @Consumes(value={"application/octet-stream"})
    @Produces(value={"application/json"})
    public Response deployZip(@PathParam(value="domain") String domainName, InputStream uploadedInputStream) throws IOException {
        if (this.isEnabled()) {
            try {
                Domain domain = this.domainService.getDomain(domainName);
                if (domain == null) {
                    this.domainService.deploy(domainName, IOUtils.toByteArray((InputStream)uploadedInputStream));
                    return Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)("{ \"application\":{\"name\":\"" + domainName + "\"}, \"status\":\"Deployment attempt started\" }")).build();
                }
                this.domainService.redeploy(domainName, IOUtils.toByteArray((InputStream)uploadedInputStream));
                return Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)("{ \"application\":{\"name\":\"" + domainName + "\"}, \"status\":\"Deployment attempt started\" }")).build();
            }
            catch (ConcurrentDeploymentException e) {
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("{\"errorType\":\"" + ((Object)((Object)e)).getClass() + "\", \"errorMessage\":\"" + e.getMessage() + "\" }")).build();
            }
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)("{\"errorType\":\"" + IllegalAccessException.class + "\", \"errorMessage\":\"Message handler is disabled\" }")).build();
    }

    @DELETE
    @Path(value="{domain}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response undeploy(@PathParam(value="domain") String domainName) {
        if (this.isEnabled()) {
            try {
                Domain domain = this.domainService.getDomain(domainName);
                if (domain == null) {
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("{\"errorType\":\"" + NoSuchElementException.class + "\", \"errorMessage\":\"No such domain\" }")).build();
                }
                this.domainService.undeploy(domainName);
                return Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)domain).build();
            }
            catch (ConcurrentDeploymentException e) {
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("{\"errorType\":\"" + ((Object)((Object)e)).getClass() + "\", \"errorMessage\":\"" + e.getMessage() + "\" }")).build();
            }
            catch (IllegalArgumentException e) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("{\"errorType\":\"" + e.getClass() + "\", \"errorMessage\":\"" + e.getMessage() + "\" }")).build();
            }
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)("{\"errorType\":\"" + IllegalAccessException.class + "\", \"errorMessage\":\"Message handler is disabled\" }")).build();
    }

    @PUT
    @Path(value="{domain}/restart")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response redeploy(@PathParam(value="domain") String domainName) throws WebApplicationException {
        if (this.isEnabled()) {
            try {
                Domain domain = this.domainService.getDomain(domainName);
                if (domain == null) {
                    return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("{\"errorType\":\"" + NoSuchElementException.class + "\", \"errorMessage\":\"No such domain\" }")).build();
                }
                this.domainService.redeploy(domainName);
                return Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)domain).build();
            }
            catch (ConcurrentDeploymentException e) {
                return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("{\"errorType\":\"" + ((Object)((Object)e)).getClass() + "\", \"errorMessage\":\"" + e.getMessage() + "\" }")).build();
            }
            catch (IllegalArgumentException e) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("{\"errorType\":\"" + e.getClass() + "\", \"errorMessage\":\"" + e.getMessage() + "\" }")).build();
            }
        }
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)("{\"errorType\":\"" + IllegalAccessException.class + "\", \"errorMessage\":\"Message handler is disabled\" }")).build();
    }
}

