/*
 * Decompiled with CFR 0.152.
 */
package org.mule.datasense.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.mule.datasenseapi.api.DataSenseComponentInfo;
import org.mule.datasenseapi.api.DataSenseElementInfo;
import org.mule.datasenseapi.api.DataSenseInfo;
import org.mule.datasenseapi.api.notifications.DataSenseNotification;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.source.SourceModel;

public class DefaultDataSenseInfo
implements DataSenseInfo,
DataSenseComponentInfo,
DataSenseElementInfo {
    private final Location location;
    private final OperationModel operationModel;
    private final SourceModel sourceModel;
    private final MetadataType input;
    private final MetadataType output;
    private final MetadataType incoming;
    private final MetadataType expected;
    private final MetadataType result;
    private final MetadataType expectedInput;
    private final List<String> messages;
    private final List<DataSenseNotification> dataSenseNotifications;
    private final Map<Location, DataSenseElementInfo> componentInfoByComponentPath;
    private final Map<String, MetadataType> globalBindings;
    private final Map<String, MetadataType> functionBindings;

    public DefaultDataSenseInfo(Location location, OperationModel operationModel, SourceModel sourceModel, MetadataType input, MetadataType output, MetadataType incoming, MetadataType expected, MetadataType result, MetadataType expectedInput, List<String> messages, List<DataSenseNotification> dataSenseNotifications, Map<Location, DataSenseElementInfo> componentInfoByComponentPath, Map<String, MetadataType> globalBindings, Map<String, MetadataType> functionBindings) {
        this.location = location;
        this.operationModel = operationModel;
        this.sourceModel = sourceModel;
        this.input = input;
        this.output = output;
        this.incoming = incoming;
        this.expected = expected;
        this.result = result;
        this.expectedInput = expectedInput;
        this.componentInfoByComponentPath = componentInfoByComponentPath;
        if (messages != null) {
            this.messages = new ArrayList<String>(messages.size());
            this.messages.addAll(messages);
        } else {
            this.messages = new ArrayList<String>();
        }
        if (dataSenseNotifications != null) {
            this.dataSenseNotifications = new ArrayList<DataSenseNotification>(dataSenseNotifications.size());
            this.dataSenseNotifications.addAll(dataSenseNotifications);
        } else {
            this.dataSenseNotifications = new ArrayList<DataSenseNotification>();
        }
        this.globalBindings = new HashMap<String, MetadataType>();
        if (globalBindings != null) {
            this.globalBindings.putAll(globalBindings);
        }
        this.functionBindings = new HashMap<String, MetadataType>();
        if (functionBindings != null) {
            this.functionBindings.putAll(functionBindings);
        }
    }

    public DefaultDataSenseInfo(Location location, OperationModel operationModel, SourceModel sourceModel, MetadataType input, MetadataType output, MetadataType incoming, MetadataType expected, MetadataType result, MetadataType expectedInput, List<String> messages, List<DataSenseNotification> dataSenseNotifications, Map<Location, DataSenseElementInfo> componentInfoByComponentPath) {
        this(location, operationModel, sourceModel, input, output, incoming, expected, result, expectedInput, messages, dataSenseNotifications, componentInfoByComponentPath, null, null);
    }

    public Location getLocation() {
        return this.location;
    }

    public Optional<MetadataType> getInput() {
        return Optional.ofNullable(this.input);
    }

    public Optional<MetadataType> getOutput() {
        return Optional.ofNullable(this.output);
    }

    public Optional<MetadataType> getIncoming() {
        return Optional.ofNullable(this.incoming);
    }

    public Optional<MetadataType> getExpected() {
        return Optional.ofNullable(this.expected);
    }

    public Optional<MetadataType> getActualInput() {
        return this.getIncoming();
    }

    public Optional<MetadataType> getActualOutput() {
        return this.getResult();
    }

    public Optional<MetadataType> getExpectedInput() {
        return Optional.ofNullable(this.expectedInput);
    }

    public Optional<MetadataType> getExpectedOutput() {
        return this.getExpected();
    }

    public Optional<MetadataType> getResult() {
        return Optional.ofNullable(this.result);
    }

    public Optional<OperationModel> getOperationModel() {
        return Optional.ofNullable(this.operationModel);
    }

    public Optional<SourceModel> getSourceModel() {
        return Optional.ofNullable(this.sourceModel);
    }

    public List<String> getMessages() {
        return this.messages;
    }

    public List<DataSenseNotification> getDataSenseNotifications() {
        return this.dataSenseNotifications;
    }

    public Optional<Map<Location, DataSenseElementInfo>> getComponentInfoByComponentPath() {
        return Optional.ofNullable(this.componentInfoByComponentPath);
    }

    public Map<String, MetadataType> getGlobalBindings() {
        return this.globalBindings;
    }

    public Map<String, MetadataType> getFunctionBindings() {
        return this.functionBindings;
    }
}

