/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.cfg.internal.node;

import java.util.function.Predicate;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.cfg.api.ChainExecutionPathTree;
import org.mule.runtime.cfg.api.ChainExecutionPathTreeVisitor;

public class ReferencedChainNode
implements ChainExecutionPathTree {
    private final ComponentAst referencingAst;
    private final LazyValue<ChainExecutionPathTree> referenced;
    private boolean beingIterated;

    public ReferencedChainNode(ComponentAst componentAst, LazyValue<ChainExecutionPathTree> ref) {
        this.referencingAst = componentAst;
        this.referenced = ref;
    }

    @Override
    public boolean anyExecutionPathContains(Predicate<ChainExecutionPathTree> predicate) {
        if (this.beingIterated) {
            return false;
        }
        this.beingIterated = true;
        boolean result = predicate.test(this) || ((ChainExecutionPathTree)this.referenced.get()).anyExecutionPathContains(predicate);
        this.beingIterated = false;
        return result;
    }

    @Override
    public boolean allExecutionPathsContain(Predicate<ChainExecutionPathTree> predicate) {
        if (this.beingIterated) {
            return false;
        }
        this.beingIterated = true;
        boolean result = predicate.test(this) || ((ChainExecutionPathTree)this.referenced.get()).allExecutionPathsContain(predicate);
        this.beingIterated = false;
        return result;
    }

    @Override
    public void accept(ChainExecutionPathTreeVisitor visitor) {
        if (this.beingIterated) {
            return;
        }
        visitor.visitReferencedOperation(this);
        this.beingIterated = true;
        ((ChainExecutionPathTree)this.referenced.get()).accept(visitor);
        this.beingIterated = false;
        visitor.finishReferencedOperation(this);
    }

    @Override
    public ComponentAst getComponentAst() {
        return this.referencingAst;
    }
}

