/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.dataconnection;

import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nonnull;

public class DataConnectionResource {
    private final String type;
    private final String[] name;

    public DataConnectionResource(@Nonnull String type, @Nonnull String name) {
        this.type = Objects.requireNonNull(type);
        this.name = new String[]{Objects.requireNonNull(name)};
    }

    public DataConnectionResource(@Nonnull String type, String ... name) {
        this.type = Objects.requireNonNull(type);
        this.name = Objects.requireNonNull(name);
    }

    @Nonnull
    public String type() {
        return this.type;
    }

    @Nonnull
    public String[] name() {
        return this.name;
    }

    public String toString() {
        return "Resource{type='" + this.type + "', name='" + Arrays.toString(this.name) + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataConnectionResource dataConnectionResource = (DataConnectionResource)o;
        if (!this.type.equalsIgnoreCase(dataConnectionResource.type)) {
            return false;
        }
        return Arrays.equals(this.name, dataConnectionResource.name);
    }

    public int hashCode() {
        int result = this.type.toLowerCase(Locale.ROOT).hashCode();
        result = 31 * result + Arrays.hashCode(this.name);
        return result;
    }
}

