/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.namespace;

import com.hazelcast.config.ConfigAccessor;
import com.hazelcast.config.UserCodeNamespaceConfig;
import com.hazelcast.config.UserCodeNamespacesConfig;
import com.hazelcast.internal.metrics.DynamicMetricsProvider;
import com.hazelcast.internal.monitor.impl.LocalUserCodeNamespaceStats;
import com.hazelcast.internal.namespace.ResourceDefinition;
import com.hazelcast.internal.services.StatisticsAwareService;
import java.util.Collection;
import java.util.concurrent.Callable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface UserCodeNamespaceService
extends StatisticsAwareService<LocalUserCodeNamespaceStats>,
DynamicMetricsProvider {
    public static final String SERVICE_NAME = "hz:impl:namespaceService";
    public static final String DEFAULT_NAMESPACE_NAME = "default";

    public void addNamespace(@Nonnull String var1, @Nonnull Collection<ResourceDefinition> var2);

    public boolean hasNamespace(String var1);

    public boolean isEnabled();

    public boolean isDefaultNamespaceDefined();

    public void setupNamespace(@Nullable String var1);

    public void cleanupNamespace(@Nullable String var1);

    public void runWithNamespace(@Nullable String var1, Runnable var2);

    public <V> V callWithNamespace(@Nullable String var1, Callable<V> var2);

    public ClassLoader getClassLoaderForNamespace(String var1);

    default public void addNamespaceConfig(UserCodeNamespacesConfig namespacesConfig, UserCodeNamespaceConfig namespaceConfig) {
        ConfigAccessor.addNamespaceConfigLocally(namespacesConfig, namespaceConfig);
        this.addNamespace(namespaceConfig.getName(), ConfigAccessor.getResourceDefinitions(namespaceConfig));
    }
}

