/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.config.PartitioningAttributeConfig;
import com.hazelcast.config.PartitioningStrategyConfig;
import com.hazelcast.internal.nio.ClassLoaderUtil;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.partition.PartitioningStrategy;
import com.hazelcast.partition.strategy.AttributePartitioningStrategy;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;

public final class PartitioningStrategyFactory {
    final ConcurrentHashMap<String, PartitioningStrategy> cache = new ConcurrentHashMap();
    private final ClassLoader configClassLoader;

    public PartitioningStrategyFactory(ClassLoader configClassLoader) {
        this.configClassLoader = configClassLoader;
    }

    @Nullable
    public PartitioningStrategy getPartitioningStrategy(String mapName, PartitioningStrategyConfig config, List<PartitioningAttributeConfig> attributeConfigs) {
        if (attributeConfigs != null && !attributeConfigs.isEmpty()) {
            return this.cache.computeIfAbsent(mapName, k -> this.createAttributePartitionStrategy(attributeConfigs));
        }
        if (config != null && config.getPartitioningStrategy() != null) {
            return config.getPartitioningStrategy();
        }
        if (config != null && config.getPartitioningStrategyClass() != null) {
            PartitioningStrategy strategy = this.cache.get(mapName);
            if (strategy != null) {
                return strategy;
            }
            try {
                strategy = (PartitioningStrategy)ClassLoaderUtil.newInstance(this.configClassLoader, config.getPartitioningStrategyClass());
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow(e);
            }
            this.cache.putIfAbsent(mapName, strategy);
            return strategy;
        }
        return null;
    }

    private PartitioningStrategy createAttributePartitionStrategy(List<PartitioningAttributeConfig> attributes) {
        String[] args = (String[])attributes.stream().map(PartitioningAttributeConfig::getAttributeName).toArray(String[]::new);
        return new AttributePartitioningStrategy(args);
    }

    public void removePartitioningStrategyFromCache(String mapName) {
        this.cache.remove(mapName);
    }
}

