/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.mule.framework.api.execution.MuleExecutionFramework;
import org.mule.framework.api.extension.config.ConfigurationHandler;
import org.mule.framework.api.extension.config.fluent.ConfigurationCreationCommand;
import org.mule.framework.api.tooling.MuleToolingFramework;
import org.mule.framework.internal.InternalMuleFramework;
import org.mule.framework.internal.builder.artifact.FrameworkDeployableArtifact;
import org.mule.framework.internal.extension.DietMuleExecutionFramework;
import org.mule.framework.internal.extension.config.ConfigurationHandlerRegistry;
import org.mule.framework.internal.extension.config.DietConfigurationHandler;
import org.mule.framework.internal.extension.config.InternalConfigurationHandler;
import org.mule.framework.internal.extension.config.fluent.DietConfigurationCreationCommand;
import org.mule.framework.internal.tooling.DietToolingFramework;
import org.mule.framework.internal.util.MuleFrameworkUtils;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;
import org.mule.runtime.api.metadata.MetadataStorage;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.apikit.metadata.api.MetadataService;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.connector.ConnectionManager;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.core.api.util.func.CheckedConsumer;
import org.mule.runtime.extension.api.client.ExtensionsClient;
import org.mule.runtime.extension.api.dsl.syntax.resolver.DslSyntaxResolver;
import org.mule.runtime.extension.api.runtime.config.ConfigurationProvider;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;
import org.mule.runtime.metadata.api.cache.ComponentParameterizationMetadataCacheIdGenerator;
import org.mule.runtime.metadata.api.cache.ComponentParameterizationMetadataCacheIdGeneratorFactory;
import org.mule.runtime.metadata.api.cache.ConfigurationMetadataCacheIdGenerator;
import org.mule.runtime.metadata.api.cache.ConfigurationMetadataCacheIdGeneratorFactory;
import org.mule.runtime.module.artifact.activation.api.deployable.DeployableProjectModel;
import org.mule.runtime.module.extension.internal.runtime.config.ConfigurationCreationUtils;
import org.mule.runtime.module.extension.internal.runtime.config.ConfigurationProviderFactory;
import org.mule.runtime.module.extension.internal.runtime.config.DefaultConfigurationProviderFactory;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.authcode.AuthorizationCodeOAuthHandler;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.clientcredentials.ClientCredentialsOAuthHandler;
import org.mule.runtime.module.extension.internal.runtime.connectivity.oauth.ocs.PlatformManagedOAuthHandler;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;
import org.mule.runtime.module.service.api.manager.ServiceManager;

public class DietMuleFramework
implements InternalMuleFramework {
    private final ServiceManager serviceManager;
    private final FrameworkDeployableArtifact frameworkDeployableArtifact;
    private final Optional<InternalMuleFramework> parentMuleFramework;
    private final Set<ExtensionModel> extensionModels;
    private final MuleContext muleContext;
    private final DietToolingFramework toolingFramework;
    private final DietMuleExecutionFramework executionFramework;
    private final ConfigurationHandlerRegistry configurationHandlerRegistry = new ConfigurationHandlerRegistry();
    private final ReflectionCache reflectionCache;
    private final ConfigurationProviderFactory configurationProviderFactory = new DefaultConfigurationProviderFactory();
    private final DslResolvingContext dslResolvingContext;
    private final Map<String, DslSyntaxResolver> syntaxResolvers = new ConcurrentHashMap<String, DslSyntaxResolver>();
    private final Registry registry;
    private final LazyValue<AuthorizationCodeOAuthHandler> authorizationCodeOAuthHandler;
    private final LazyValue<ClientCredentialsOAuthHandler> clientCredentialsOAuthHandler;
    private final LazyValue<PlatformManagedOAuthHandler> platformManagedOAuthHandler;
    private final LazyValue<ExtensionsClient> extensionsClient;
    private final LazyValue<ConnectionManager> connectionManager;
    private final LazyValue<MetadataService> apiKitMetadataService;
    private final ExpressionLanguageMetadataService expressionLanguageMetadataService;
    private final MetadataStorage metadataStorage;
    private final ConfigurationMetadataCacheIdGenerator configIdGenerator = new ConfigurationMetadataCacheIdGeneratorFactory().create();
    private final ComponentParameterizationMetadataCacheIdGenerator idGenerator = new ComponentParameterizationMetadataCacheIdGeneratorFactory().create(this.configIdGenerator);

    public DietMuleFramework(MuleContext muleContext, Registry registry, ServiceManager serviceManager, Set<ExtensionModel> extensionModels, FrameworkDeployableArtifact frameworkDeployableArtifact, Optional<InternalMuleFramework> parentMuleFramework, ExpressionLanguageMetadataService expressionLanguageMetadataService, MetadataStorage metadataStorage) {
        this.serviceManager = serviceManager;
        this.frameworkDeployableArtifact = frameworkDeployableArtifact;
        this.parentMuleFramework = parentMuleFramework;
        this.extensionModels = Collections.unmodifiableSet(new HashSet<ExtensionModel>(extensionModels));
        this.muleContext = muleContext;
        this.dslResolvingContext = DslResolvingContext.getDefault(extensionModels);
        this.registry = registry;
        this.authorizationCodeOAuthHandler = this.lazyLookup(AuthorizationCodeOAuthHandler.class);
        this.clientCredentialsOAuthHandler = this.lazyLookup(ClientCredentialsOAuthHandler.class);
        this.platformManagedOAuthHandler = this.lazyLookup(PlatformManagedOAuthHandler.class);
        this.reflectionCache = this.lookup(ReflectionCache.class);
        this.extensionsClient = this.lazyLookup(ExtensionsClient.class);
        this.connectionManager = this.lazyLookup(ConnectionManager.class);
        this.apiKitMetadataService = this.lazyLookup(MetadataService.class);
        this.expressionLanguageMetadataService = expressionLanguageMetadataService;
        this.toolingFramework = new DietToolingFramework(this);
        this.executionFramework = new DietMuleExecutionFramework(this);
        this.metadataStorage = metadataStorage;
    }

    public Optional<ExtensionModel> getExtensionModel(String name) {
        return this.extensionModels.stream().filter(em -> em.getName().equals(name)).findAny();
    }

    public Set<ExtensionModel> getExtensionModels() {
        return this.extensionModels;
    }

    public Optional<DeployableProjectModel> getDeployableProjectModel() {
        return this.frameworkDeployableArtifact.getDeployableProjectModel();
    }

    public Optional<ArtifactAst> getArtifactAst() {
        return Optional.ofNullable(this.frameworkDeployableArtifact.getArtifactAst());
    }

    public ConfigurationHandler createExtensionConfiguration(String extensionName, String configModelName, Consumer<ConfigurationCreationCommand> command) {
        ExtensionModel extensionModel = MuleFrameworkUtils.getExtensionModel(this, extensionName);
        ConfigurationModel configurationModel = (ConfigurationModel)extensionModel.getConfigurationModel(configModelName).orElseThrow(() -> new IllegalArgumentException(String.format("Extension '%s' does not have a config model with name '%s'", extensionName, configModelName)));
        ConfigurationProvider configurationProvider = (ConfigurationProvider)ClassUtils.withContextClassLoader((ClassLoader)this.getClassLoader(extensionModel), () -> {
            DietConfigurationCreationCommand request = new DietConfigurationCreationCommand(extensionModel, configurationModel, this);
            command.accept(request);
            return ConfigurationCreationUtils.createConfigurationProvider((ExtensionModel)extensionModel, (ConfigurationModel)configurationModel, (String)request.getName(), request.getParameters(), Optional.empty(), request.getConnectionProviderResolver(), (ConfigurationProviderFactory)this.configurationProviderFactory, (ExpressionManager)this.getExpressionManager(), (ReflectionCache)this.getReflectionCache(), (String)"", (DslSyntaxResolver)this.getDslSyntaxResolver(extensionModel), (ClassLoader)this.getClassLoader(extensionModel), (MuleContext)this.getMuleContext());
        });
        this.muleContext.getExtensionManager().registerConfigurationProvider(configurationProvider);
        DietConfigurationHandler handler = new DietConfigurationHandler(configurationProvider, (CheckedConsumer<InternalConfigurationHandler>)((CheckedConsumer)this::dispose));
        this.configurationHandlerRegistry.registerConfigurationHandler(handler);
        return handler;
    }

    private void dispose(InternalConfigurationHandler handler) {
        this.configurationHandlerRegistry.unregisterConfigurationHandler(handler);
        this.muleContext.getExtensionManager().unregisterConfigurationProvider(handler.getConfigurationProvider());
    }

    public MuleExecutionFramework getExecutionFramework() {
        this.assertStarted();
        return this.executionFramework;
    }

    public MuleToolingFramework getToolingFramework() {
        this.assertStarted();
        return this.toolingFramework;
    }

    @Override
    public ExpressionManager getExpressionManager() {
        this.assertStarted();
        return this.muleContext.getExpressionManager();
    }

    @Override
    public void start() throws MuleException {
        this.muleContext.start();
    }

    @Override
    public void assertStarted() throws IllegalStateException {
        if (!this.muleContext.isStarted()) {
            throw new IllegalStateException("Mule Frameworks is not started (" + this.muleContext.getLifecycleManager().getCurrentPhase() + ")");
        }
        this.parentMuleFramework.ifPresent(InternalMuleFramework::assertStarted);
    }

    @Override
    public Collection<ComponentAst> getConfigurations() {
        return Collections.emptyList();
    }

    public void close() throws Exception {
        this.configurationHandlerRegistry.closeAllConfigs();
        this.muleContext.stop();
        this.muleContext.dispose();
        this.serviceManager.stop();
        this.frameworkDeployableArtifact.dispose();
    }

    public DslSyntaxResolver getDslSyntaxResolver(ExtensionModel extensionModel) {
        return this.syntaxResolvers.computeIfAbsent(extensionModel.getName(), name -> DslSyntaxResolver.getDefault((ExtensionModel)extensionModel, (DslResolvingContext)this.dslResolvingContext));
    }

    @Override
    public ReflectionCache getReflectionCache() {
        return this.reflectionCache;
    }

    @Override
    public ConnectionManager getConnectionManager() {
        return (ConnectionManager)this.connectionManager.get();
    }

    @Override
    public ExtensionsClient getExtensionsClient() {
        return (ExtensionsClient)this.extensionsClient.get();
    }

    @Override
    public ConfigurationProperties getConfigurationProperties() {
        return this.frameworkDeployableArtifact.getConfigurationProperties();
    }

    @Override
    public ExpressionLanguageMetadataService getExpressionLanguageMetadataService() {
        return this.expressionLanguageMetadataService;
    }

    @Override
    public MetadataService getApiKitMetadataService() {
        return (MetadataService)this.apiKitMetadataService.get();
    }

    @Override
    public AuthorizationCodeOAuthHandler getAuthorizationCodeOAuthHandler() {
        return (AuthorizationCodeOAuthHandler)this.authorizationCodeOAuthHandler.get();
    }

    @Override
    public ClientCredentialsOAuthHandler getClientCredentialsOAuthHandler() {
        return (ClientCredentialsOAuthHandler)this.clientCredentialsOAuthHandler.get();
    }

    @Override
    public PlatformManagedOAuthHandler getPlatformManagedOAuthHandler() {
        return (PlatformManagedOAuthHandler)this.platformManagedOAuthHandler.get();
    }

    @Override
    public ClassLoader getExecutionClassLoader() {
        return this.muleContext.getExecutionClassLoader();
    }

    @Override
    public MuleContext getMuleContext() {
        return this.muleContext;
    }

    @Override
    public ServiceManager getServiceManager() {
        return this.serviceManager;
    }

    @Override
    public Registry getRegistry() {
        return this.registry;
    }

    @Override
    public MetadataStorage getMetadataStorage() {
        return this.metadataStorage;
    }

    @Override
    public ComponentParameterizationMetadataCacheIdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    @Override
    public ConfigurationMetadataCacheIdGenerator getConfigIdGenerator() {
        return this.configIdGenerator;
    }

    @Override
    public boolean isRegistered(ConfigurationHandler configurationHandler) {
        return this.configurationHandlerRegistry.isRegistered(configurationHandler);
    }

    @Override
    public FrameworkDeployableArtifact getFrameworkDeployableArtifact() {
        return this.frameworkDeployableArtifact;
    }

    @Override
    public Optional<ConfigurationHandler> getConfigurationHandler(String name) {
        return this.configurationHandlerRegistry.getConfigurationHandler(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T onExecutionClassLoader(Callable<T> task) throws Exception {
        Thread currentThread = Thread.currentThread();
        ClassLoader originalClassLoader = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(this.getExecutionClassLoader());
        try {
            T t = task.call();
            return t;
        }
        finally {
            currentThread.setContextClassLoader(originalClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onExecutionClassLoader(Runnable task) {
        Thread currentThread = Thread.currentThread();
        ClassLoader originalClassLoader = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(this.getExecutionClassLoader());
        try {
            task.run();
        }
        finally {
            currentThread.setContextClassLoader(originalClassLoader);
        }
    }

    public TypedValue evaluateExpression(String expression, BindingContext bindingContext) {
        return this.getExpressionManager().evaluate(expression, bindingContext);
    }

    private <T> T lookup(Class<T> clazz) {
        return this.registry.lookupByType(clazz).orElse(null);
    }

    private <T> LazyValue<T> lazyLookup(Class<T> clazz) {
        return new LazyValue(() -> this.lookup(clazz));
    }

    private ClassLoader getClassLoader(ExtensionModel extensionModel) {
        return (ClassLoader)ExtensionModelUtils.getExtensionClassLoader((ExtensionModel)extensionModel).orElse(this.frameworkDeployableArtifact.getExecutionClassLoader());
    }

    public Stream<ComponentAst> getConfigsAst() {
        return this.frameworkDeployableArtifact.getConfigurationsAsts().map(Collection::stream).orElse(Stream.empty());
    }
}

