/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.framework.api.extension.config.ConfigurationHandler;
import org.mule.framework.api.extension.connection.fluent.ConnectionConfigurer;
import org.mule.framework.internal.DietMuleFramework;
import org.mule.framework.internal.InternalMuleFramework;
import org.mule.framework.internal.builder.artifact.FrameworkDeployableArtifact;
import org.mule.framework.internal.extension.connection.parser.DietConnectionParserUtils;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;
import org.mule.runtime.api.metadata.MetadataStorage;
import org.mule.runtime.api.parameterization.ComponentParameterization;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.util.MuleAstUtils;
import org.mule.runtime.ast.graph.api.ArtifactAstDependencyGraph;
import org.mule.runtime.ast.graph.api.ArtifactAstDependencyGraphFactory;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.module.service.api.manager.ServiceManager;

public class DietMuleFrameworkWithConfigurations
extends DietMuleFramework {
    private final LazyValue<ArtifactAstDependencyGraph> artifactAstDependencyGraph;
    private final Set<String> configsCreated = new HashSet<String>();
    private final Map<String, Object> configsCreationLocks = new ConcurrentHashMap<String, Object>();
    private final FrameworkDeployableArtifact frameworkDeployableArtifact;

    public DietMuleFrameworkWithConfigurations(MuleContext muleContext, Registry registry, ServiceManager serviceManager, Set<ExtensionModel> extensionModels, FrameworkDeployableArtifact frameworkDeployableArtifact, Optional<InternalMuleFramework> parentMuleFramework, ExpressionLanguageMetadataService expressionLanguageMetadataService, MetadataStorage metadataStorage) {
        super(muleContext, registry, serviceManager, extensionModels, frameworkDeployableArtifact, parentMuleFramework, expressionLanguageMetadataService, metadataStorage);
        this.frameworkDeployableArtifact = frameworkDeployableArtifact;
        this.artifactAstDependencyGraph = new LazyValue(() -> ArtifactAstDependencyGraphFactory.generateFor((ArtifactAst)frameworkDeployableArtifact.getArtifactAst()));
    }

    @Override
    public Collection<ComponentAst> getConfigurations() {
        return this.frameworkDeployableArtifact.getConfigurationsAsts().orElse(Collections.emptySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<ConfigurationHandler> getConfigurationHandler(String name) {
        Optional<ConfigurationHandler> configurationHandler = super.getConfigurationHandler(name);
        if (!configurationHandler.isPresent() && !this.configsCreated.contains(name)) {
            Object object = this.configsCreationLocks.computeIfAbsent(name, k -> new Object());
            synchronized (object) {
                if (!this.configsCreated.contains(name)) {
                    Set totalConfigsAsts = ((ArtifactAstDependencyGraph)this.artifactAstDependencyGraph.get()).getRequiredComponents(name).stream().filter(componentAst -> componentAst.getComponentType().equals((Object)TypedComponentIdentifier.ComponentType.CONFIG)).filter(componentAst -> componentAst.getComponentId().isPresent()).collect(Collectors.toSet());
                    Set<ComponentAst> requiredConfigsAsts = totalConfigsAsts.stream().filter(componentAst -> !((String)componentAst.getComponentId().get()).equals(name)).collect(Collectors.toSet());
                    requiredConfigsAsts.forEach(requiredConfigAst -> this.getConfigurationHandler((String)requiredConfigAst.getComponentId().get()));
                    configurationHandler = totalConfigsAsts.stream().filter(componentAst -> ((String)componentAst.getComponentId().get()).equals(name)).map(this::createConfig).findFirst();
                    this.configsCreated.add(name);
                }
            }
        }
        return configurationHandler;
    }

    private ConfigurationHandler createConfig(ComponentAst configAst) {
        String configName = (String)configAst.getComponentId().orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)String.format("Attempted to create a configuration with no name in location '%s'", configAst.getLocation()))));
        ComponentParameterization configModel = MuleAstUtils.createComponentParameterizationFromComponentAst((ComponentAst)configAst);
        String extensionName = configAst.getExtensionModel().getName();
        String configModelName = configModel.getModel().getName();
        return this.createExtensionConfiguration(extensionName, configModelName, command -> {
            command.name(configName);
            configModel.getParameters().forEach((parameter, value) -> command.withParameter(((ParameterGroupModel)parameter.getFirst()).getName(), ((ParameterModel)parameter.getSecond()).getName(), value));
            configAst.directChildrenStream().filter(connectionAst -> connectionAst.getModel(ConnectionProviderModel.class).isPresent()).forEach(connectionAst -> {
                ConnectionProviderModel connectionModel = (ConnectionProviderModel)connectionAst.getModel(ConnectionProviderModel.class).get();
                ConnectionConfigurer connectionConfigurer = command.connectingThrough(connectionModel.getName());
                ComponentParameterization connectionParameterization = MuleAstUtils.createComponentParameterizationFromComponentAst((ComponentAst)connectionAst);
                ArrayList<Pair<String, Optional<String>>> alreadyProcessedParameters = new ArrayList<Pair<String, Optional<String>>>();
                DietConnectionParserUtils.parseOAuthConfigFromParameterization(connectionConfigurer, (ComponentParameterization<ParameterizedModel>)connectionParameterization, connectionModel, alreadyProcessedParameters);
                DietConnectionParserUtils.parseReconnectionConfigFromParameterization(connectionConfigurer, (ComponentParameterization<ParameterizedModel>)connectionParameterization, alreadyProcessedParameters, configName);
                DietConnectionParserUtils.parsePoolingProfileConfigFromParameterization(connectionConfigurer, (ComponentParameterization<ParameterizedModel>)connectionParameterization, alreadyProcessedParameters);
                DietConnectionParserUtils.parseTlsConfigFromParameterization(connectionConfigurer, (ComponentParameterization<ParameterizedModel>)connectionParameterization, alreadyProcessedParameters);
                connectionParameterization.forEachParameter((paramGroup, param, paramValue) -> {
                    if (!this.isParameterProcessed(paramGroup.getName(), param.getName(), alreadyProcessedParameters)) {
                        connectionConfigurer.withParameter(paramGroup.getName(), param.getName(), paramValue);
                    }
                });
            });
        });
    }

    private boolean isParameterProcessed(String paramGroupName, String paramName, Collection<Pair<String, Optional<String>>> alreadyProcessedParameters) {
        return alreadyProcessedParameters.contains(new Pair((Object)paramGroupName, Optional.empty())) || alreadyProcessedParameters.contains(new Pair((Object)paramGroupName, Optional.of(paramName)));
    }

    @Override
    public Optional<ArtifactAst> getArtifactAst() {
        return Optional.of(this.frameworkDeployableArtifact.getArtifactAst());
    }

    @Override
    public Stream<ComponentAst> getConfigsAst() {
        return this.frameworkDeployableArtifact.getConfigurationsAsts().map(Collection::stream).orElse(Stream.empty());
    }
}

