/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.builder.application;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.mule.framework.api.builder.FrameworkApplicationConfigurer;
import org.mule.framework.api.builder.PluginBuilder;
import org.mule.framework.internal.builder.application.AbstractFrameworkApplicationConfigurer;
import org.mule.framework.internal.builder.application.DefaultFrameworkApplication;
import org.mule.framework.internal.builder.configurations.InternalConfigurationsCreationConfigurer;
import org.mule.framework.internal.builder.domain.FrameworkDomain;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.module.artifact.activation.api.deployable.DeployableProjectModel;
import org.mule.runtime.module.artifact.activation.api.descriptor.DeployableArtifactDescriptorFactory;
import org.mule.runtime.module.artifact.activation.api.plugin.PluginModelResolver;
import org.mule.runtime.module.artifact.api.classloader.MuleDeployableArtifactClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.ApplicationDescriptor;

public abstract class AbstractFrameworkApplicationFromProjectConfigurer
extends AbstractFrameworkApplicationConfigurer {
    public FrameworkApplicationConfigurer withResources(List<Path> resources) {
        throw new UnsupportedOperationException("Not supported when building from an application project");
    }

    public FrameworkApplicationConfigurer withPluginModelResolver(PluginModelResolver pluginModelResolver) {
        throw new UnsupportedOperationException("Not supported when building from an application project");
    }

    public PluginBuilder withPlugin(String groupId, String artifactId, String version) {
        throw new UnsupportedOperationException("Not supported when building from an application project");
    }

    @Override
    protected ApplicationDescriptor createApplicationDescriptor(Map<String, String> deploymentProperties, Set<URL> folderUrls) {
        DeployableProjectModel model = this.createDeployableProjectModel();
        model.validate();
        try {
            File target;
            for (Path resource : model.getResourcesPath()) {
                folderUrls.add(resource.toUri().toURL());
            }
            if (!model.getPackages().isEmpty() && (target = new File(model.getProjectFolder(), "target/classes")).exists()) {
                folderUrls.add(target.toURI().toURL());
            }
        }
        catch (MalformedURLException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
        return DeployableArtifactDescriptorFactory.defaultArtifactDescriptorFactory().createApplicationDescriptor(model, deploymentProperties, this.getDomainDescriptorResolver());
    }

    @Override
    protected DefaultFrameworkApplication getFrameworkApplication(MuleDeployableArtifactClassLoader applicationClassLoader, InternalConfigurationsCreationConfigurer configsCreationConfigurer, boolean dslValidations) {
        return new DefaultFrameworkApplication(applicationClassLoader, Optional.of(this.createDeployableProjectModel()), configsCreationConfigurer, this.getDomainFramework().map(dFwk -> (FrameworkDomain)dFwk.getFrameworkDeployableArtifact()), dslValidations);
    }

    protected abstract DeployableProjectModel createDeployableProjectModel();
}

