/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.builder.application;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.mule.framework.api.MuleFramework;
import org.mule.framework.api.builder.FrameworkApplicationConfigurer;
import org.mule.framework.api.builder.PluginBuilder;
import org.mule.framework.api.dependency.DependencyResolutionException;
import org.mule.framework.api.dependency.DependencyResolver;
import org.mule.framework.internal.builder.application.AbstractFrameworkApplicationConfigurer;
import org.mule.framework.internal.builder.application.DefaultFrameworkApplication;
import org.mule.framework.internal.builder.application.DietPluginBuilder;
import org.mule.framework.internal.builder.application.FromPluginsFrameworkApplication;
import org.mule.framework.internal.builder.configurations.InternalConfigurationsCreationConfigurer;
import org.mule.framework.internal.util.MuleFrameworkUtils;
import org.mule.runtime.api.deployment.meta.MuleApplicationModel;
import org.mule.runtime.api.deployment.meta.MuleArtifactLoaderDescriptor;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.module.artifact.activation.api.deployable.DeployableProjectModel;
import org.mule.runtime.module.artifact.activation.api.descriptor.DeployableArtifactDescriptorCreator;
import org.mule.runtime.module.artifact.activation.api.descriptor.DeployableArtifactDescriptorFactory;
import org.mule.runtime.module.artifact.activation.api.descriptor.DomainDescriptorResolver;
import org.mule.runtime.module.artifact.activation.api.plugin.PluginDescriptorResolver;
import org.mule.runtime.module.artifact.activation.api.plugin.PluginModelResolver;
import org.mule.runtime.module.artifact.api.classloader.MuleDeployableArtifactClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.ApplicationDescriptor;
import org.mule.runtime.module.artifact.api.descriptor.BundleDependency;
import org.mule.runtime.module.artifact.api.descriptor.BundleDescriptor;

public class FrameworkApplicationFromPluginsConfigurer
extends AbstractFrameworkApplicationConfigurer {
    public static final String EMPTY_PROJECT_NAME = "<empty>";
    private static final BundleDescriptor EMPTY_APP_BUNDLE_DESCRIPTOR = new BundleDescriptor.Builder().setGroupId("com.mulesoft.fwk.temp").setArtifactId("<empty>").setVersion("0.0.1").setBaseVersion("0.0.1").setType("jar").setClassifier("mule-application").build();
    private List<Path> resourcesPaths = Collections.emptyList();
    private PluginModelResolver pluginModelResolver = PluginModelResolver.pluginModelResolver();
    private final List<DietPluginBuilder> pluginBuilders = new ArrayList<DietPluginBuilder>();
    private final DependencyResolver dependencyResolver;

    public FrameworkApplicationFromPluginsConfigurer(DependencyResolver dependencyResolver) {
        this.dependencyResolver = dependencyResolver;
    }

    @Override
    public FrameworkApplicationConfigurer withConfigurations() {
        throw new IllegalStateException("In order to create configurations an artifact AST must be provided.");
    }

    public FrameworkApplicationConfigurer withResources(List<Path> resources) {
        if (resources == null) {
            throw new IllegalArgumentException("'resources' cannot be null");
        }
        if (!this.resourcesPaths.isEmpty()) {
            throw new IllegalStateException("'resources' is already set");
        }
        this.resourcesPaths = resources;
        return this;
    }

    public FrameworkApplicationConfigurer withPluginModelResolver(PluginModelResolver pluginModelResolver) {
        if (pluginModelResolver == null) {
            throw new IllegalArgumentException("'pluginModelResolver' cannot be null");
        }
        if (this.pluginModelResolver != PluginModelResolver.pluginModelResolver()) {
            throw new IllegalStateException("'pluginModelResolver' is already set");
        }
        this.pluginModelResolver = pluginModelResolver;
        return this;
    }

    public PluginBuilder withPlugin(String groupId, String artifactId, String version) {
        BundleDependency resolvedBundleDependency;
        try {
            resolvedBundleDependency = this.dependencyResolver.resolveFor(new BundleDescriptor.Builder().setGroupId(groupId).setArtifactId(artifactId).setVersion(version).setBaseVersion(version).setType("jar").setClassifier("mule-plugin").build());
        }
        catch (DependencyResolutionException e) {
            throw new IllegalArgumentException(e);
        }
        DietPluginBuilder pluginBuilder = new DietPluginBuilder(this, this.dependencyResolver, resolvedBundleDependency);
        this.pluginBuilders.add(pluginBuilder);
        return pluginBuilder;
    }

    @Override
    public FrameworkApplicationConfigurer withDomain(Function<BundleDescriptor, MuleFramework> domainMuleFrameworkResolver) {
        throw new UnsupportedOperationException("'withDomain' not supported when building from plugins");
    }

    @Override
    protected void validateConfigurer(InternalConfigurationsCreationConfigurer configsCreationConfigurer) {
        if (configsCreationConfigurer.getArtifactAst() == null) {
            throw new IllegalStateException("In order to create configurations an artifact AST must be provided.");
        }
    }

    @Override
    protected DefaultFrameworkApplication getFrameworkApplication(MuleDeployableArtifactClassLoader applicationClassLoader, InternalConfigurationsCreationConfigurer configsCreationConfigurer, boolean dslValidations) {
        return new FromPluginsFrameworkApplication(applicationClassLoader, configsCreationConfigurer, dslValidations);
    }

    @Override
    protected ApplicationDescriptor createApplicationDescriptor(Map<String, String> deploymentProperties, Set<URL> folderUrls) {
        Path createTempDirectory;
        try {
            createTempDirectory = Files.createTempDirectory(null, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
        HashMap<Pair<String, String>, BundleDependency> dependencies = new HashMap<Pair<String, String>, BundleDependency>();
        HashMap<BundleDescriptor, List<BundleDependency>> additionalPluginDependencies = new HashMap<BundleDescriptor, List<BundleDependency>>();
        for (DietPluginBuilder pluginBuilder : this.pluginBuilders) {
            this.addDependency(dependencies, pluginBuilder.getPluginDependency());
            pluginBuilder.getPluginDependency().getTransitiveDependenciesList().stream().filter(transitiveDependency -> transitiveDependency.getDescriptor().isPlugin()).forEach(transitiveDependency -> this.addDependency((Map<Pair<String, String>, BundleDependency>)dependencies, (BundleDependency)transitiveDependency));
            if (pluginBuilder.getAdditionalDependencies().isEmpty()) continue;
            additionalPluginDependencies.put(pluginBuilder.getPluginDependency().getDescriptor(), pluginBuilder.getAdditionalDependencies());
        }
        ArrayList<String> resourcesNames = new ArrayList<String>();
        this.buildResourcesUrls(this.resourcesPaths, folderUrls, resourcesNames);
        MuleApplicationModel model = (MuleApplicationModel)((MuleApplicationModel.MuleApplicationModelBuilder)((MuleApplicationModel.MuleApplicationModelBuilder)((MuleApplicationModel.MuleApplicationModelBuilder)((MuleApplicationModel.MuleApplicationModelBuilder)new MuleApplicationModel.MuleApplicationModelBuilder().setName(EMPTY_PROJECT_NAME)).setMinMuleVersion("4.5.0")).withBundleDescriptorLoader(new MuleArtifactLoaderDescriptor("mule", Collections.emptyMap()))).withClassLoaderModelDescriptorLoader(new MuleArtifactLoaderDescriptor("mule", Collections.singletonMap("exportedResources", resourcesNames)))).build();
        DeployableProjectModel wrapperAppModel = new DeployableProjectModel(Collections.emptyList(), Collections.emptyList(), this.resourcesPaths, EMPTY_APP_BUNDLE_DESCRIPTOR, () -> model, createTempDirectory.toFile(), new ArrayList(dependencies.values()), Collections.emptySet(), additionalPluginDependencies);
        wrapperAppModel.validate();
        return DeployableArtifactDescriptorFactory.defaultArtifactDescriptorFactory().createApplicationDescriptor(wrapperAppModel, deploymentProperties, this.pluginModelResolver, PluginDescriptorResolver.pluginDescriptorResolver(), DomainDescriptorResolver.noDomainDescriptorResolver(), DeployableArtifactDescriptorCreator.applicationDescriptorCreator());
    }

    private void buildResourcesUrls(List<Path> resources, Set<URL> folderUrls, List<String> resourcesNames) {
        HashSet resourcesNamesSet = new HashSet();
        resources.forEach(resourceFolder -> {
            try {
                File resourceFile = resourceFolder.toFile();
                if (!resourceFile.exists()) {
                    throw new IllegalArgumentException(resourceFile.getName() + " not exists");
                }
                if (!resourceFile.isDirectory()) {
                    folderUrls.add(resourceFile.getParentFile().toURI().toURL());
                    if (resourcesNamesSet.contains(resourceFile.getName())) {
                        throw new IllegalArgumentException("Duplicated resources: " + resourceFile.getName());
                    }
                    resourcesNamesSet.add(resourceFile.getName());
                } else {
                    folderUrls.add(resourceFile.toURI().toURL());
                    Files.walk(resourceFolder, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(file -> resourceFolder.relativize((Path)file).toString()).forEach(fileName -> {
                        if (resourcesNamesSet.contains(fileName)) {
                            throw new IllegalArgumentException("Duplicated resources: " + resourceFile.getName());
                        }
                        resourcesNamesSet.add(fileName);
                    });
                }
            }
            catch (IOException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        });
        resourcesNames.addAll(resourcesNamesSet);
    }

    private void addDependency(Map<Pair<String, String>, BundleDependency> dependencies, BundleDependency dependency) {
        Pair artifactId = new Pair((Object)dependency.getDescriptor().getGroupId(), (Object)dependency.getDescriptor().getArtifactId());
        if (dependencies.containsKey(artifactId) && !MuleFrameworkUtils.mustOverrideArtifact(dependencies.get(artifactId).getDescriptor(), dependency.getDescriptor())) {
            return;
        }
        dependencies.put((Pair<String, String>)artifactId, dependency);
    }
}

