/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.builder.service;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.mule.framework.api.ServiceConfigurer;
import org.mule.framework.api.dependency.DependencyResolver;
import org.mule.framework.internal.builder.service.MuleFrameworkServiceDiscoverer;
import org.mule.framework.internal.service.CustomServiceLifecycleProxyInvocationHandler;
import org.mule.framework.internal.service.SharedServiceLifecycleProxyInvocationHandler;
import org.mule.framework.internal.service.noop.NoOpApiKitMetadataService;
import org.mule.framework.internal.service.noop.NoOpExpressionLanguageMetadataService;
import org.mule.framework.internal.service.noop.NoOpOAuthService;
import org.mule.runtime.api.el.DefaultExpressionLanguageFactoryService;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.metadata.ExpressionLanguageMetadataService;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.service.Service;
import org.mule.runtime.apikit.metadata.api.MetadataService;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.service.api.manager.ServiceManager;
import org.mule.runtime.module.service.api.manager.ServiceRegistry;
import org.mule.runtime.oauth.api.OAuthService;

public class MuleFrameworkServiceConfigurerBuilder
implements ServiceConfigurer {
    private static final String ARTIFACTID_DW_EE_SERVICE = "mule-service-weave-ee";
    private static final String DATA_WEAVE_SERVICE_NAME = "service/DataWeave service";
    private static final String GROUPID_DW_EE_SERVICE = "com.mulesoft.services";
    private static final String GROUPID_RUNTIME_EE_SERVICES = "com.mulesoft.mule.services";
    private static ServiceRegistry defaultServiceRegistry = ServiceRegistry.create();
    private final Map<Class<? extends Service>, Service> customServices = new HashMap<Class<? extends Service>, Service>();
    private final ArtifactClassLoader containerClassLoader;
    private final DependencyResolver dependencyResolver;
    private Map<Class<? extends Service>, Function<MuleFrameworkServiceDiscoverer, Service>> explodedFolderServicesFactories;
    private boolean toolingServicesEnabled;
    private boolean oAuthServiceEnabled;

    private static Map<Class<? extends Service>, Function<MuleFrameworkServiceDiscoverer, Service>> defaultServicesFactories() {
        HashMap<Class<? extends Service>, Function<MuleFrameworkServiceDiscoverer, Service>> defaultServices = new HashMap<Class<? extends Service>, Function<MuleFrameworkServiceDiscoverer, Service>>();
        defaultServices.put(SchedulerService.class, serviceDiscoverer -> serviceDiscoverer.createService(SchedulerService.class, "org.mule.fwk", "mule-framework-service-diet-scheduler", "service/Scheduler service"));
        defaultServices.put(DefaultExpressionLanguageFactoryService.class, serviceDiscoverer -> serviceDiscoverer.createService(DefaultExpressionLanguageFactoryService.class, GROUPID_DW_EE_SERVICE, ARTIFACTID_DW_EE_SERVICE, DATA_WEAVE_SERVICE_NAME));
        defaultServices.put(HttpService.class, serviceDiscoverer -> serviceDiscoverer.createService(HttpService.class, GROUPID_RUNTIME_EE_SERVICES, "mule-service-http-ee", "service/HTTP EE service"));
        defaultServices.put(MetadataService.class, serviceDiscoverer -> serviceDiscoverer.isToolingServicesEnabled() ? serviceDiscoverer.createService(MetadataService.class, "org.mule.services", "mule-service-apikit-metadata", "service/Apikit Metadata service") : new NoOpApiKitMetadataService());
        defaultServices.put(ExpressionLanguageMetadataService.class, serviceDiscoverer -> serviceDiscoverer.isToolingServicesEnabled() ? serviceDiscoverer.createService(ExpressionLanguageMetadataService.class, GROUPID_DW_EE_SERVICE, ARTIFACTID_DW_EE_SERVICE, DATA_WEAVE_SERVICE_NAME) : new NoOpExpressionLanguageMetadataService());
        defaultServices.put(OAuthService.class, serviceDiscoverer -> serviceDiscoverer.isOAuthServiceEnabled() ? serviceDiscoverer.createService(OAuthService.class, GROUPID_RUNTIME_EE_SERVICES, "mule-service-oauth-ee", "service/OAUTH EE service") : new NoOpOAuthService());
        return defaultServices;
    }

    public static void disposeServices() {
        defaultServiceRegistry.getAllServices().forEach(MuleFrameworkServiceConfigurerBuilder::disposeService);
    }

    private static void disposeService(Service service) {
        InvocationHandler invocationHandler;
        if (Proxy.isProxyClass(service.getClass()) && (invocationHandler = Proxy.getInvocationHandler(service)) instanceof SharedServiceLifecycleProxyInvocationHandler) {
            try {
                ((SharedServiceLifecycleProxyInvocationHandler)((Object)invocationHandler)).forceStop();
            }
            catch (MuleException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }
    }

    public MuleFrameworkServiceConfigurerBuilder(ArtifactClassLoader containerClassLoader, DependencyResolver dependencyResolver) {
        this.containerClassLoader = containerClassLoader;
        this.dependencyResolver = dependencyResolver;
    }

    public ServiceConfigurer withExplodedServicesFrom(Path servicesBundleDir) {
        if (this.explodedFolderServicesFactories != null) {
            throw new IllegalStateException("`withExplodedServicesFrom` was already calles for this configurer.");
        }
        if (!servicesBundleDir.toFile().exists()) {
            throw new IllegalArgumentException("servicesBundleDir `" + servicesBundleDir.toFile().getAbsolutePath() + "` does not exist.");
        }
        if (!servicesBundleDir.toFile().isDirectory()) {
            throw new IllegalArgumentException("servicesBundleDir `" + servicesBundleDir.toFile().getAbsolutePath() + "` is NOT a directory.");
        }
        HashMap<Class<? extends Service>, Function<MuleFrameworkServiceDiscoverer, Service>> servicesFactories = new HashMap<Class<? extends Service>, Function<MuleFrameworkServiceDiscoverer, Service>>();
        servicesFactories.put(SchedulerService.class, serviceDiscoverer -> serviceDiscoverer.createService(SchedulerService.class, "org.mule.fwk", "mule-framework-service-diet-scheduler", "service/Scheduler service", servicesBundleDir));
        servicesFactories.put(DefaultExpressionLanguageFactoryService.class, serviceDiscoverer -> serviceDiscoverer.createService(DefaultExpressionLanguageFactoryService.class, GROUPID_DW_EE_SERVICE, ARTIFACTID_DW_EE_SERVICE, DATA_WEAVE_SERVICE_NAME, servicesBundleDir));
        servicesFactories.put(HttpService.class, serviceDiscoverer -> serviceDiscoverer.createService(HttpService.class, GROUPID_RUNTIME_EE_SERVICES, "mule-service-http-ee", "service/HTTP EE service", servicesBundleDir));
        servicesFactories.put(MetadataService.class, serviceDiscoverer -> serviceDiscoverer.isToolingServicesEnabled() ? serviceDiscoverer.createService(MetadataService.class, "org.mule.services", "mule-service-apikit-metadata", "service/Apikit Metadata service", servicesBundleDir) : new NoOpApiKitMetadataService());
        servicesFactories.put(ExpressionLanguageMetadataService.class, serviceDiscoverer -> serviceDiscoverer.isToolingServicesEnabled() ? serviceDiscoverer.createService(ExpressionLanguageMetadataService.class, GROUPID_DW_EE_SERVICE, ARTIFACTID_DW_EE_SERVICE, DATA_WEAVE_SERVICE_NAME, servicesBundleDir) : new NoOpExpressionLanguageMetadataService());
        servicesFactories.put(OAuthService.class, serviceDiscoverer -> serviceDiscoverer.isOAuthServiceEnabled() ? serviceDiscoverer.createService(OAuthService.class, GROUPID_RUNTIME_EE_SERVICES, "mule-service-oauth-ee", "service/OAUTH EE service", servicesBundleDir) : new NoOpOAuthService());
        this.explodedFolderServicesFactories = servicesFactories;
        return this;
    }

    public ServiceConfigurer withSchedulerService(SchedulerService service) {
        return this.withService(SchedulerService.class, service);
    }

    public ServiceConfigurer withExpressionLanguageFactoryService(DefaultExpressionLanguageFactoryService service) {
        return this.withService(DefaultExpressionLanguageFactoryService.class, service);
    }

    private <S extends Service> ServiceConfigurer withService(Class<S> serviceInterface, S service) {
        if (service == null) {
            throw new IllegalArgumentException("'service' cannot be null");
        }
        if (this.customServices.containsKey(serviceInterface)) {
            throw new IllegalStateException("Service with interface '" + serviceInterface.getName() + "' is already set");
        }
        this.customServices.put(serviceInterface, (Service)Proxy.newProxyInstance(service.getClass().getClassLoader(), new Class[]{serviceInterface, Startable.class, Stoppable.class}, (InvocationHandler)((Object)new CustomServiceLifecycleProxyInvocationHandler(defaultServiceRegistry, serviceInterface, service))));
        return this;
    }

    public ServiceConfigurer enableToolingServices() {
        this.toolingServicesEnabled = true;
        return this;
    }

    public ServiceConfigurer enableOAuthService() {
        this.oAuthServiceEnabled = true;
        return this;
    }

    public ServiceManager getServiceManager() {
        MuleFrameworkServiceDiscoverer muleFrameworkServiceDiscoverer;
        try {
            muleFrameworkServiceDiscoverer = new MuleFrameworkServiceDiscoverer(this.containerClassLoader, this.dependencyResolver, defaultServiceRegistry, this.toolingServicesEnabled, this.oAuthServiceEnabled);
        }
        catch (IOException e2) {
            throw new MuleRuntimeException((Throwable)e2);
        }
        Map<Class<? extends Service>, Function<MuleFrameworkServiceDiscoverer, Service>> servicesFactories = this.explodedFolderServicesFactories != null ? this.explodedFolderServicesFactories : MuleFrameworkServiceConfigurerBuilder.defaultServicesFactories();
        List services = servicesFactories.entrySet().stream().map(e -> {
            Class serviceInterface = (Class)e.getKey();
            Service service = this.customServices.containsKey(serviceInterface) ? this.customServices.get(serviceInterface) : (Service)((Function)e.getValue()).apply(muleFrameworkServiceDiscoverer);
            return service;
        }).collect(Collectors.toList());
        return ServiceManager.create(() -> new ArrayList(services));
    }

    @Deprecated
    public static void resetServiceRegistry() {
        defaultServiceRegistry = ServiceRegistry.create();
        MuleFrameworkServiceDiscoverer.classLoaderEntryByGroupArtifact.clear();
    }
}

