/*
 * Decompiled with CFR 0.152.
 */
package org.mule.framework.internal.tooling.type.propagation.cfg;

import java.util.ArrayDeque;
import java.util.Deque;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.message.api.MessageMetadataType;
import org.mule.metadata.message.api.MessageMetadataTypeBuilder;

public class MessageTracker {
    private final Deque<MetadataType> payload = new ArrayDeque<MetadataType>();
    private final Deque<MetadataType> attributes = new ArrayDeque<MetadataType>();

    public MessageTracker(MetadataType initialPayloadType, MetadataType initialAttributeType) {
        this.payload.push(initialPayloadType);
        this.attributes.push(initialAttributeType);
    }

    public MetadataType getCurrentPayload() {
        return this.payload.peek();
    }

    public MetadataType getCurrentAttributes() {
        return this.attributes.peek();
    }

    public MessageMetadataType getFullMessageType() {
        return new MessageMetadataTypeBuilder().payload(this.getCurrentPayload()).attributes(this.getCurrentAttributes()).build();
    }

    public void setMessageTypes(MetadataType payload, MetadataType attributes) {
        this.setPayload(payload);
        this.setAttributes(attributes);
    }

    public void setMessageTypes(MessageMetadataType type) {
        type.getPayloadType().ifPresent(this::setPayload);
        type.getAttributesType().ifPresent(this::setAttributes);
    }

    public void setPayload(MetadataType type) {
        this.payload.pop();
        this.payload.push(type);
    }

    public void setAttributes(MetadataType type) {
        if (type == null) {
            type = new BaseTypeBuilder(MetadataFormat.JAVA).voidType().build();
        }
        this.attributes.pop();
        this.attributes.push(type);
    }

    public void saveCurrentState() {
        this.payload.push(this.getCurrentPayload());
        this.attributes.push(this.getCurrentAttributes());
    }

    public void revertCurrentState() {
        this.payload.pop();
        this.attributes.pop();
    }
}

