/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal;

import java.util.HashSet;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.tooling.client.api.component.location.ArtifactComponentLocations;
import org.mule.tooling.client.api.component.location.ComponentLocation;
import org.mule.tooling.client.api.component.location.ComponentLocationService;
import org.mule.tooling.client.internal.Command;
import org.mule.tooling.client.internal.ComponentLocationFactory;
import org.mule.tooling.client.internal.serialization.Serializer;

public class DefaultComponentLocationService
implements ComponentLocationService,
Command {
    private Serializer serializer;
    private LazyValue<ArtifactComponentLocations> artifactComponentLocations;

    public DefaultComponentLocationService(LazyValue<ArtifactAst> applicationModelLazyValue, Serializer serializer) {
        this.serializer = serializer;
        this.artifactComponentLocations = new LazyValue(() -> {
            HashSet componentLocations = new HashSet();
            ((ArtifactAst)applicationModelLazyValue.get()).recursiveStream().forEach(componentModel -> {
                if (componentModel.getLocation() != null) {
                    componentLocations.add(this.convertComponentLocation(componentModel.getLocation()));
                }
            });
            return new ArtifactComponentLocations(componentLocations);
        });
    }

    public ArtifactComponentLocations getComponentLocations() {
        return (ArtifactComponentLocations)this.artifactComponentLocations.get();
    }

    private ComponentLocation convertComponentLocation(org.mule.runtime.api.component.location.ComponentLocation componentLocation) {
        return ComponentLocationFactory.toComponentLocationDTO(componentLocation);
    }

    @Override
    public Object invokeMethod(String methodName, String[] classes, String[] arguments) {
        switch (methodName) {
            case "getComponentLocations": {
                Preconditions.checkState((arguments.length == 0 ? 1 : 0) != 0, (String)String.format("Wrong number of arguments when invoking method created on %s", this.getClass().getName()));
                return this.serializer.serialize((Object)this.getComponentLocations());
            }
        }
        throw Command.methodNotFound(this.getClass(), methodName);
    }
}

