/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.client.internal.serialization;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.tooling.client.internal.serialization.TypeAnnotationsTransformers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeAnnotationMapWriter {
    private static Logger LOGGER = LoggerFactory.getLogger(TypeAnnotationMapWriter.class);
    private List<Class> alreadyLoggedNotSupportedTypeAnnotations = new ArrayList<Class>();
    private ClassLoader targetClassLoader;
    private List<Class> typeAnnotationsNotSupportedByToolingRuntimeClient;

    public TypeAnnotationMapWriter(ClassLoader targetClassLoader, List<Class> typeAnnotationsNotSupportedByToolingRuntimeClient) {
        this.targetClassLoader = targetClassLoader;
        this.typeAnnotationsNotSupportedByToolingRuntimeClient = typeAnnotationsNotSupportedByToolingRuntimeClient;
    }

    public Map write(Map map) {
        if (TypeAnnotationMapWriter.isTypeAnnotationMap(map)) {
            Map typeAnnotationMap = map;
            LinkedHashMap<Class, TypeAnnotation> toTypeAnnotationTransformedMap = new LinkedHashMap<Class, TypeAnnotation>();
            for (Map.Entry entry : typeAnnotationMap.entrySet()) {
                if (!((TypeAnnotation)entry.getValue()).isPublic()) continue;
                if (!this.typeAnnotationsNotSupportedByToolingRuntimeClient.contains(entry.getKey())) {
                    try {
                        if (TypeAnnotationsTransformers.typeAnnotationTransformers.containsKey(entry.getKey())) {
                            TypeAnnotation transformed = (TypeAnnotation)TypeAnnotationsTransformers.typeAnnotationTransformers.get(entry.getKey()).transform((Object)((TypeAnnotation)entry.getValue()));
                            this.targetClassLoader.loadClass(transformed.getClass().getName());
                            toTypeAnnotationTransformedMap.put(transformed.getClass(), transformed);
                            continue;
                        }
                        toTypeAnnotationTransformedMap.put((Class)entry.getKey(), (TypeAnnotation)entry.getValue());
                    }
                    catch (ClassNotFoundException e) {
                        this.typeAnnotationsNotSupportedByToolingRuntimeClient.add((Class)entry.getKey());
                    }
                    continue;
                }
                if (this.alreadyLoggedNotSupportedTypeAnnotations.contains(entry.getKey())) continue;
                this.alreadyLoggedNotSupportedTypeAnnotations.add((Class)entry.getKey());
                LOGGER.warn(String.format("Ignored TypeAnnotation '%s' as it is not supported by Tooling API", entry.getKey()));
            }
            return toTypeAnnotationTransformedMap;
        }
        return map;
    }

    static boolean isTypeAnnotationMap(Map map) {
        if (map.isEmpty()) {
            return false;
        }
        return map.values().stream().filter(value -> value instanceof TypeAnnotation).findAny().isPresent();
    }
}

