/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.tooling.client.internal.application;

import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.config.internal.model.ApplicationModel;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.tooling.client.api.Disposable;
import org.mule.tooling.client.internal.ToolingArtifactContext;

import java.util.List;

/**
 * Responsible for handling Application resources and life cycle.
 *
 * @since 4.0
 */
public interface Application extends RemoteApplicationInvoker, Disposable {

  /**
   * @return a name for this application.
   */
  String getApplicationName();

  /**
   * @return builds the {@link ApplicationModel} for the application.
   */
  ApplicationModel getApplicationModel();

  /**
   * @return collects the list of {@link ExtensionModel} for the application.
   */
  List<ExtensionModel> getExtensionModels();

  /**
   * @return the {@link ArtifactClassLoader} for the application.
   */
  ArtifactClassLoader getArtifactClassLoader();

  /**
   * Sets the {@link ToolingArtifactContext} to be used by this {@link Application}. This means that if the Runtime Tooling
   * Service API has changed and it was cached the remote application deployed it will be deployed again.
   *
   * @param context {@link ToolingArtifactContext} to be used by this {@link Application}
   */
  void setContext(ToolingArtifactContext context);
}
